/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algos.abstractalgos;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractEdgeSet;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractGraphFactory;
import mascoptLib.abstractGraph.AbstractPath;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.AbstractVertexSet;
import mascoptLib.abstractGraph.MascoptFixedSet;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.Vertex;
import mascoptLib.util.Trace;

public class KShortestPath
implements Runnable {
    public static final String WEIGHT = "poids";
    static final int DISTANCE_MAX = Integer.MAX_VALUE;
    private AbstractGraph g;
    private AbstractGraph g_original;
    private int k = 10;
    private Hashtable srcTable;
    private PrintStream outputStream;
    private boolean writeMode = false;
    private int nbNode = 0;
    private AbstractVertexSet nodeSet;
    private Object[] nodes;
    private Hashtable nodeTable;
    private boolean disjoint = true;
    private Hashtable duplicatedNode = null;

    public KShortestPath(AbstractGraph g, int k) {
        this.g_original = g;
        this.g = g.getFactory().newAbstractCopyGraph(g, false);
        this.k = k;
        this.nodeSet = g.getAbstractVertexSet();
        this.nbNode = this.nodeSet.size();
        this.nodes = this.nodeSet.toArray();
        this.nodeTable = new Hashtable(this.nbNode, 1.0f);
        for (int i = 0; i < this.nbNode; ++i) {
            AbstractVertex currentNode = (AbstractVertex)this.nodes[i];
            this.nodeTable.put(currentNode, new Integer(i));
        }
    }

    public KShortestPath(AbstractGraph g) {
        this(g, 1);
    }

    public void run() {
        long debut = System.currentTimeMillis();
        Vector sav = new Vector(1, 1);
        Iterator iterator = this.nodeSet.iterator();
        Datas t = null;
        AbstractVertex currentNode = null;
        AbstractVertexSet nodeSetSubSet = this.g.getFactory().newAbstractVertexSet(this.nodeSet);
        nodeSetSubSet.setName("Copy of the node set " + this.nodeSet.getId());
        if (!this.writeMode) {
            this.srcTable = new Hashtable(this.nbNode, 1.0f);
        }
        while (iterator.hasNext()) {
            currentNode = (AbstractVertex)iterator.next();
            nodeSetSubSet.add(currentNode);
            if (this.writeMode) continue;
            this.srcTable.put(currentNode, new Hashtable(this.nbNode, 1.0f));
        }
        Iterator iterator2 = null;
        AbstractVertex source = null;
        AbstractVertex destination = null;
        Vector chemins = null;
        iterator = nodeSetSubSet.iterator();
        while (iterator.hasNext()) {
            source = currentNode = (AbstractVertex)iterator.next();
            iterator2 = nodeSetSubSet.iterator();
            if (!this.disjoint) {
                this.duplicatedNode = new Hashtable();
            }
            while (iterator2.hasNext()) {
                destination = (AbstractVertex)iterator2.next();
                Vertex sink = null;
                if (!this.disjoint) {
                    sink = new Vertex();
                    this.duplicatedNode.put(sink, destination);
                    this.g.getAbstractVertexSet().add(sink);
                }
                if (destination.equals(source)) continue;
                for (int i = 1; i <= this.k; ++i) {
                    if (this.disjoint || !this.disjoint && i == 1) {
                        t = this.getShortestPath(this.g, source, destination);
                        chemins = this.getAShortestPath(destination, t, i);
                    } else {
                        t = this.getShortestPath(this.g, source, sink);
                        chemins = this.getAShortestPath(sink, t, i);
                    }
                    if (chemins == null) {
                        this.fillEmptyPath(i + 1, source, destination);
                        break;
                    }
                    if (this.disjoint) {
                        this.removePath(this.g, chemins, sav);
                        continue;
                    }
                    this.removePath(this.g, chemins, sink, i);
                }
                if (this.disjoint) {
                    this.restorePath(this.g, sav);
                    continue;
                }
                this.restorePath(this.g);
            }
        }
        this.disjoint = true;
        Trace.println("temps de calcul:" + (System.currentTimeMillis() - debut) + "ms");
        nodeSetSubSet.free();
    }

    private void removePath(AbstractGraph graph, Vector path, Vector sav) {
        AbstractEdgeSet edges = graph.getAbstractEdgeSet();
        for (int i = 0; i < path.size(); ++i) {
            sav.add(path.elementAt(i));
            edges.remove(path.elementAt(i));
        }
    }

    private void removePath(AbstractGraph graph, Vector path, AbstractVertex sink, int j) {
        if (path.elementAt(0) == null) {
            return;
        }
        if (j > 1 && ((AbstractEdge)path.elementAt(0)).getAbstractVertices()[1].equals(sink)) {
            graph.getAbstractEdgeSet().remove(path.elementAt(0));
            path.removeElementAt(0);
        }
        AbstractEdgeSet edges = graph.getAbstractEdgeSet();
        AbstractVertexSet nodes = graph.getAbstractVertexSet();
        AbstractEdge edge = (AbstractEdge)path.elementAt(path.size() - 1);
        AbstractVertex[] linked = edge.getAbstractVertices();
        Vertex copy1 = new Vertex();
        Vertex copy2 = new Vertex();
        this.duplicatedNode.put(copy1, linked[0]);
        this.duplicatedNode.put(copy2, linked[1]);
        AbstractGraphFactory factory = graph.getFactory();
        AbstractEdge copyEdge = factory.newAbstractEdge(copy1, copy2);
        nodes.add(copy1);
        nodes.add(copy2);
        copyEdge.setValue(WEIGHT, edge.getValue(WEIGHT));
        edges.add(copyEdge);
        MascoptFixedSet in = linked[0].getIncoming(edges);
        Iterator iterator = in.iterator();
        while (iterator.hasNext()) {
            edge = (AbstractEdge)iterator.next();
            if (path.contains(edge)) continue;
            copyEdge = factory.newAbstractEdge(edge.getAbstractVertices()[0], copy1);
            copyEdge.setValue(WEIGHT, edge.getValue(WEIGHT));
            edges.add(copyEdge);
        }
        in = linked[1].getIncoming(edges);
        iterator = in.iterator();
        while (iterator.hasNext()) {
            edge = (AbstractEdge)iterator.next();
            if (path.contains(edge)) continue;
            copyEdge = factory.newAbstractEdge(edge.getAbstractVertices()[0], copy2);
            copyEdge.setValue(WEIGHT, edge.getValue(WEIGHT));
            edges.add(copyEdge);
        }
        for (int i = path.size() - 2; i >= 0; --i) {
            copy1 = copy2;
            edge = (AbstractEdge)path.elementAt(i);
            linked = edge.getAbstractVertices();
            copy2 = new Vertex();
            this.duplicatedNode.put(copy2, linked[1]);
            copyEdge = factory.newAbstractEdge(copy1, copy2);
            nodes.add(copy2);
            copyEdge.setValue(WEIGHT, edge.getValue(WEIGHT));
            edges.add(copyEdge);
            in = linked[1].getIncoming(edges);
            iterator = in.iterator();
            while (iterator.hasNext()) {
                edge = (AbstractEdge)iterator.next();
                if (path.contains(edge)) continue;
                copyEdge = factory.newAbstractEdge(edge.getAbstractVertices()[0], copy2);
                copyEdge.setValue(WEIGHT, edge.getValue(WEIGHT));
                edges.add(copyEdge);
            }
            if (i != 0) continue;
            copyEdge = factory.newAbstractEdge(copy2, sink);
            copyEdge.setValue(WEIGHT, "0");
            edges.add(copyEdge);
        }
    }

    private Vector getAShortestPath(AbstractVertex dest, Datas paths, int j) {
        AbstractVertex prec;
        AbstractVertex current;
        this.nodeTable = paths.table;
        int i = (Integer)this.nodeTable.get(dest);
        Doublet doublet = null;
        if (!this.writeMode) {
            Hashtable table = (Hashtable)this.srcTable.get(paths.src);
            if (j != 1) {
                doublet = !this.disjoint && this.duplicatedNode.get(dest) != null ? (Doublet)table.get(this.duplicatedNode.get(dest)) : (Doublet)table.get(dest);
            } else {
                doublet = new Doublet(this.k);
                if (!this.disjoint && this.duplicatedNode.get(dest) != null) {
                    table.put(this.duplicatedNode.get(dest), doublet);
                } else {
                    table.put(dest, doublet);
                }
            }
            doublet.length[j - 1] = paths.D[i];
        } else {
            this.outputStream.print(paths.D[i] + "  ");
        }
        if (paths.D[i] == -1) {
            doublet.chain[j - 1] = new Vector();
            return null;
        }
        Vector<AbstractVertex> nod = new Vector<AbstractVertex>(1, 1);
        nod.addElement(dest);
        do {
            current = paths.I[i];
            nod.addElement(current);
            i = (Integer)this.nodeTable.get(current);
        } while (!current.equals(paths.src));
        Vector<AbstractEdge> otherPath = null;
        if (!this.disjoint) {
            otherPath = new Vector<AbstractEdge>(nod.size() - 1);
            for (int k = 0; k < nod.size() - 1; ++k) {
                prec = (AbstractVertex)nod.elementAt(k);
                current = (AbstractVertex)nod.elementAt(k + 1);
                otherPath.addElement(this.getEdge(current, prec));
            }
        }
        if (!this.disjoint) {
            for (int q = 0; q < nod.size(); ++q) {
                current = (AbstractVertex)nod.elementAt(q);
                while (current != null && this.duplicatedNode.containsKey(current)) {
                    current = (AbstractVertex)this.duplicatedNode.get(current);
                    nod.setElementAt(current, q);
                }
            }
        }
        Vector<AbstractEdge> shortestPath = new Vector<AbstractEdge>(nod.size() - 1);
        for (int k = 0; k < nod.size() - 1; ++k) {
            prec = (AbstractVertex)nod.elementAt(k);
            current = (AbstractVertex)nod.elementAt(k + 1);
            shortestPath.addElement(this.getEdge(current, prec));
        }
        if (!this.writeMode) {
            doublet.chain[j - 1] = shortestPath;
        } else {
            this.outputStream.println(shortestPath);
        }
        if (this.disjoint) {
            return shortestPath;
        }
        return otherPath;
    }

    private Datas getShortestPath(AbstractGraph graph, AbstractVertex src, AbstractVertex dest) {
        int i;
        AbstractEdgeSet edgeSet = graph.getAbstractEdgeSet();
        MascoptFixedSet neighbourgs = src.getNeighbours(edgeSet);
        AbstractVertex currentNode = null;
        if (!this.disjoint) {
            this.nodes = graph.getAbstractVertexSet().toArray();
            this.nbNode = this.nodes.length;
            this.nodeTable.clear();
            for (int i2 = 0; i2 < this.nbNode; ++i2) {
                currentNode = (AbstractVertex)this.nodes[i2];
                this.nodeTable.put(currentNode, new Integer(i2));
            }
        }
        int[] D = new int[this.nbNode];
        boolean[] E = new boolean[this.nbNode];
        AbstractVertex[] I = new AbstractVertex[this.nbNode];
        for (i = 0; i < this.nbNode; ++i) {
            currentNode = (AbstractVertex)this.nodes[i];
            E[i] = false;
            if (!currentNode.equals(src)) {
                E[i] = false;
                I[i] = src;
                if (neighbourgs.contains(currentNode)) {
                    if (this.getEdge(src, currentNode).getValue(WEIGHT) == null) {
                        System.out.println("impossible de lire le poids sur l'arc " + this.getEdge(src, currentNode));
                        System.exit(0);
                    }
                    D[i] = Integer.parseInt(this.getEdge(src, currentNode).getValue(WEIGHT));
                    continue;
                }
                D[i] = -1;
                continue;
            }
            E[i] = true;
        }
        int nonDansE = this.nbNode - 1;
        int indice = -1;
        boolean destDone = false;
        while (nonDansE > 0 && !destDone) {
            int distance = Integer.MAX_VALUE;
            for (i = 0; i < this.nbNode; ++i) {
                if (E[i] || D[i] >= distance || D[i] < 0) continue;
                distance = D[i];
                indice = i;
            }
            if (indice == -1) break;
            E[indice] = true;
            --nonDansE;
            AbstractVertex t = (AbstractVertex)this.nodes[indice];
            if (t.equals(dest)) {
                destDone = true;
            }
            MascoptFixedSet currentNodeNeighbourgs = t.getNeighbours(edgeSet);
            Iterator iterator = currentNodeNeighbourgs.iterator();
            while (iterator.hasNext()) {
                currentNode = (AbstractVertex)iterator.next();
                i = (Integer)this.nodeTable.get(currentNode);
                if (E[i]) continue;
                AbstractEdge edge = this.getEdge(t, currentNode);
                int weigth = Integer.parseInt(edge.getValue(WEIGHT));
                if (D[i] >= 0 && D[indice] + weigth >= D[i]) continue;
                D[i] = D[indice] + weigth;
                I[i] = t;
            }
        }
        return new Datas(src, I, D, this.nodeTable);
    }

    private AbstractEdge getEdge(AbstractVertex src, AbstractVertex dest) {
        MascoptFixedSet edgeSet = src.getEdgesTo(this.g, dest);
        Iterator iterator = edgeSet.iterator();
        if (iterator.hasNext()) {
            AbstractEdge minWeight = null;
            int weight = Integer.MAX_VALUE;
            while (iterator.hasNext()) {
                AbstractEdge edge = (AbstractEdge)iterator.next();
                if (Integer.parseInt(edge.getValue(WEIGHT)) >= weight) continue;
                weight = Integer.parseInt(edge.getValue(WEIGHT));
                minWeight = edge;
            }
            return minWeight;
        }
        return null;
    }

    private void restorePath(AbstractGraph graph, Vector sav) {
        AbstractEdgeSet edges = graph.getAbstractEdgeSet();
        for (int i = 0; i < sav.size(); ++i) {
            edges.add((AbstractEdge)sav.elementAt(i));
        }
        sav.removeAllElements();
        sav.setSize(0);
    }

    private void restorePath(AbstractGraph graph) {
        AbstractVertexSet set = graph.getAbstractVertexSet();
        Enumeration enumeration = this.duplicatedNode.keys();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            set.remove(o);
        }
        this.duplicatedNode.clear();
    }

    private void fillEmptyPath(int i, AbstractVertex src, AbstractVertex dest) {
        if (this.writeMode) {
            for (int z = i - 1; z < this.k; ++z) {
                Vector<Object> v = new Vector<Object>(1, 1);
                Object edge = null;
                v.addElement(edge);
                this.outputStream.println("-1  " + v);
            }
        } else {
            Hashtable destTable = (Hashtable)this.srcTable.get(src);
            Doublet doublet = (Doublet)destTable.get(dest);
            for (int z = i - 1; z < this.k; ++z) {
                doublet.length[z] = -1;
                doublet.chain[z] = new Vector(1, 1);
                doublet.chain[z].addElement(null);
            }
        }
    }

    public Vector getShortestPath(AbstractVertex src, AbstractVertex dest) {
        Vector<AbstractPath> v = new Vector<AbstractPath>(1, 1);
        if (!src.equals(dest)) {
            for (int i = 0; i < this.k; ++i) {
                Vector w = ((Doublet)((Hashtable)this.srcTable.get((Object)src)).get((Object)dest)).chain[i];
                AbstractPath chain = this.g.getFactory().newAbstractPath(this.g_original.getAbstractEdgeSet());
                chain.setName("Chaine solutions de l'algo KShortestPath (" + chain.getId());
                for (int j = 0; j < w.size(); ++j) {
                    boolean ok;
                    if (w.elementAt(j) == null || (ok = chain.concatAbstractEdge((Arc)w.elementAt(j)))) continue;
                    System.err.println("Error: construction of the result chain fails !");
                }
                if (chain == null) {
                    System.out.println("Erreur:  null chain object !");
                }
                if (chain.toString().equals("null")) continue;
                v.add(chain);
            }
        }
        return v;
    }

    public Vector getShortestPath(AbstractVertex src, AbstractVertex dest, int j) {
        if (src.equals(dest)) {
            Vector<Object> v = new Vector<Object>(1, 1);
            v.addElement(null);
            return v;
        }
        return ((Doublet)((Hashtable)this.srcTable.get((Object)src)).get((Object)dest)).chain[j - 1];
    }

    public int[] getShortestPathLength(AbstractVertex src, AbstractVertex dest) {
        if (src.equals(dest)) {
            return new int[this.k];
        }
        return ((Doublet)((Hashtable)this.srcTable.get((Object)src)).get((Object)dest)).length;
    }

    public int getShortestPathLength(AbstractVertex src, AbstractVertex dest, int j) {
        if (src.equals(dest)) {
            return 0;
        }
        return ((Doublet)((Hashtable)this.srcTable.get((Object)src)).get((Object)dest)).length[j - 1];
    }

    public static int getPathLength(AbstractPath chain) {
        if (chain == null) {
            return -1;
        }
        AbstractEdgeSet chainSet = chain.getAbstractEdgeSet();
        Iterator iterator = chainSet.iterator();
        int length = 0;
        while (iterator.hasNext()) {
            AbstractEdge edge = (AbstractEdge)iterator.next();
            String poids = edge.getValue(WEIGHT);
            if (poids == null) {
                System.out.println("impossible de lire le poids sur l'arc " + edge);
                System.exit(0);
            }
            length += Integer.parseInt(poids);
        }
        return length;
    }

    public void write(String file) {
        try {
            this.outputStream = new PrintStream(new FileOutputStream(new File(file)));
            this.writeMode = true;
            this.run();
            this.outputStream.close();
        }
        catch (IOException e) {
            System.out.println("cannot create file " + file);
        }
    }

    public void writenonDisjoint(String file) {
        try {
            this.outputStream = new PrintStream(new FileOutputStream(new File(file)));
            this.writeMode = true;
            this.runNonDisjoint();
            this.outputStream.close();
        }
        catch (IOException e) {
            System.out.println("cannot create file " + file);
        }
    }

    public void runNonDisjoint() {
        this.disjoint = false;
        this.run();
    }

    public Vector getShortestPath(AbstractEdge e) {
        return this.getShortestPath(e.getAbstractVertices()[0], e.getAbstractVertices()[1]);
    }

    private class Doublet {
        Vector[] chain;
        int[] length;

        public Doublet(int k) {
            this.length = new int[k];
            this.chain = new Vector[k];
        }
    }

    private class Datas {
        AbstractVertex src;
        AbstractVertex[] I;
        int[] D;
        Hashtable table;

        public Datas(AbstractVertex src, AbstractVertex[] I, int[] D, Hashtable table) {
            this.src = src;
            this.I = I;
            this.D = D;
            this.table = table;
        }
    }
}

