/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algos.abstractalgos;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractPath;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.MascoptFixedSet;
import mascoptLib.algos.abstractalgos.Dijkstra;
import mascoptLib.algos.abstractalgos.PathGenerator;
import mascoptLib.graphs.Arc;

public class PathBreadthFirstSearch
extends PathGenerator {
    public int numberOfPaths = 50;
    public int maxLength = Integer.MAX_VALUE;

    public PathBreadthFirstSearch(AbstractGraph g, AbstractGraph requests) {
        super(g, requests);
    }

    public void run() {
        System.out.print("Generating " + this.numberOfPaths + " paths with maxLength=" + this.maxLength + " for each request...");
        this.pathsForEachZ = new HashMap();
        Iterator itRequest = this.requests_.getAbstractEdgeSet().iterator();
        int nbPathTotal = 0;
        while (itRequest.hasNext()) {
            System.out.print(".");
            Arc z = (Arc)itRequest.next();
            HashSet<AbstractPath> solution_this_z = new HashSet<AbstractPath>();
            this.pathsForEachZ.put(z, solution_this_z);
            LinkedList<AbstractVertex> pile = new LinkedList<AbstractVertex>();
            LinkedList<AbstractPath> pilePath = new LinkedList<AbstractPath>();
            pile.addLast(z.getTail());
            int nb_path = 0;
            int shortest_path = this.getDistance(z);
            int current_length = 0;
            while (nb_path < this.numberOfPaths && pile.size() > 0 && current_length <= this.maxLength + shortest_path) {
                AbstractVertex current_node = (AbstractVertex)pile.removeFirst();
                AbstractPath current_path = pilePath.size() == 0 ? this.g_.getFactory().newAbstractPath(this.g_.getAbstractEdgeSet()) : (AbstractPath)pilePath.removeFirst();
                MascoptFixedSet out_edges = current_node.getOutgoing(this.g_);
                Iterator it_neighbors = out_edges.iterator();
                while (it_neighbors.hasNext()) {
                    AbstractPath newP;
                    Arc edgeOut = (Arc)it_neighbors.next();
                    AbstractVertex nodeOut = edgeOut.getConnected(current_node);
                    if (nodeOut != z.getHead()) {
                        if (current_path.getAbstractVertexSet().contains(nodeOut)) continue;
                        pile.addLast(nodeOut);
                        newP = this.g_.getFactory().newAbstractCopyPath(current_path);
                        newP.concatAbstractEdge(edgeOut);
                        pilePath.addLast(newP);
                        continue;
                    }
                    ++nb_path;
                    ++nbPathTotal;
                    newP = this.g_.getFactory().newAbstractCopyPath(current_path);
                    newP.concatAbstractEdge(edgeOut);
                    solution_this_z.add(newP);
                    current_length = newP.getAbstractEdgeSet().size();
                }
            }
        }
        System.out.println("");
        System.out.println("Generated paths: " + nbPathTotal);
    }

    int getDistance(Arc z) {
        Dijkstra dijkstra = new Dijkstra(this.g_);
        this.g_.getAbstractEdgeSet().setValueForAllElements("distanceForDijkstra", "1");
        dijkstra.DIJKSTRADISTANCE = "distanceForDijkstra";
        dijkstra.valuateFromSource(z.getTail());
        return dijkstra.getDistanceTo(z.getHead());
    }
}

