/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algos.abstractalgos;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractPath;
import mascoptLib.algos.abstractalgos.Dijkstra;
import mascoptLib.util.Trace;

public class PathGenerator {
    protected AbstractGraph g_;
    protected AbstractGraph requests_;
    protected HashMap pathsForEachZ;
    protected boolean protection_ = false;

    public PathGenerator(AbstractGraph g, AbstractGraph requests) {
        this.g_ = g.getFactory().newAbstractCopyGraph(g, false);
        this.requests_ = requests;
    }

    public void run() {
        System.out.print("Generating paths sets...");
        int nb_paths_gen = 0;
        int nb_paths_gen_r = 0;
        this.pathsForEachZ = new HashMap();
        Iterator itRequest = this.requests_.getAbstractEdgeSet().iterator();
        while (itRequest.hasNext()) {
            AbstractEdge z = (AbstractEdge)itRequest.next();
            HashSet pathsForThisZ = new HashSet();
            AbstractPath p = this.addPath(pathsForThisZ, z);
            ++nb_paths_gen;
            if (this.protection_) {
                if (p != null) {
                    Iterator itEdge = p.getAbstractEdgeSet().iterator();
                    while (itEdge.hasNext()) {
                        AbstractEdge z_of_p = (AbstractEdge)itEdge.next();
                        this.g_.getAbstractEdgeSet().remove(z_of_p);
                        this.addPath(pathsForThisZ, z);
                        ++nb_paths_gen_r;
                        this.g_.getAbstractEdgeSet().add(z_of_p);
                    }
                } else {
                    System.out.println("Erreur: Pas de chemin pour cette requete !");
                }
                System.out.print(".");
            }
            this.pathsForEachZ.put(z, pathsForThisZ);
        }
        System.out.println("\nMain paths generated: " + nb_paths_gen);
        System.out.println("Disjoint paths generated: " + nb_paths_gen_r);
    }

    public HashMap getPaths() {
        return this.pathsForEachZ;
    }

    public HashSet getPathsForThisEdge(AbstractEdge z) {
        return (HashSet)this.pathsForEachZ.get(z);
    }

    protected AbstractPath addPath(HashSet paths, AbstractEdge z) {
        Dijkstra dijkstra = new Dijkstra(this.g_);
        dijkstra.valuateFromSource(z.getAbstractVertices()[0]);
        AbstractPath p = dijkstra.getShortestPathTo(z.getAbstractVertices()[1]);
        AbstractPath p_copy = null;
        if (p != null) {
            p_copy = this.g_.getFactory().newAbstractCopyPath(p);
            paths.add(p_copy);
            Trace.println("For r: " + z + "Chemin p: " + p_copy);
            p.free();
        }
        return p_copy;
    }

    public void computeDisjointPathsForGeneratedPaths(boolean protection) {
        this.protection_ = protection;
    }
}

