/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algos.abstractalgos;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractPath;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.MascoptFixedSet;
import mascoptLib.algos.abstractalgos.DijkstraAdvanced;
import mascoptLib.algos.abstractalgos.PathGenerator;
import mascoptLib.util.Trace;

public class PathGeneratorRandomWalk
extends PathGenerator {
    protected AbstractGraph original_graph;
    protected int nb_paths = 1;
    protected int nb_paths_r = 1;
    protected Random generateur;
    protected HashSet edge_for_this_set_of_paths = null;
    protected String code_distance_dijkstra = "distance_pour_dijkstra_advanced";
    private int cpt_MAX = 0;
    public int MAXSIZE = 500;
    public int stretch_factor = 5;

    public PathGeneratorRandomWalk(AbstractGraph g, AbstractGraph requests) {
        super(g, requests);
        this.original_graph = g;
        this.generateur = new Random();
        this.cpt_MAX = this.g_.getAbstractVertexSet().size();
        this.edge_for_this_set_of_paths = new HashSet();
        Iterator ite = this.g_.getAbstractEdgeSet().iterator();
        while (ite.hasNext()) {
            AbstractEdge e = (AbstractEdge)ite.next();
            e.setDoubleValue(this.code_distance_dijkstra, this.g_, new Double(1.0));
        }
    }

    public void setNbPathsForRequest(int number) {
        this.nb_paths = number;
    }

    public void setDisjointNbPathsForRequest(int number) {
        this.nb_paths_r = number;
    }

    public void run() {
        System.out.println("Random Walk: Stretch factor: " + this.stretch_factor);
        System.out.print("Generating paths sets...");
        this.pathsForEachZ = new HashMap();
        int nb_paths_gen = 0;
        int nb_paths_gen_r = 0;
        Iterator itRequest = this.requests_.getAbstractEdgeSet().iterator();
        while (itRequest.hasNext()) {
            this.edge_for_this_set_of_paths.clear();
            AbstractEdge z = (AbstractEdge)itRequest.next();
            HashMap chemins = new HashMap();
            this.addPath(z, this.nb_paths, true, chemins);
            nb_paths_gen += this.nb_paths;
            if (this.protection_) {
                Iterator itEdges = this.edge_for_this_set_of_paths.iterator();
                while (itEdges.hasNext()) {
                    AbstractEdge e = (AbstractEdge)itEdges.next();
                    this.g_.getAbstractEdgeSet().remove(e);
                    this.addPath(z, this.nb_paths_r, false, chemins);
                    nb_paths_gen_r += this.nb_paths_r;
                    this.g_.getAbstractEdgeSet().add(e);
                }
            }
            HashSet pathsForThisZ = new HashSet(chemins.values());
            this.pathsForEachZ.put(z, pathsForThisZ);
            Trace.println("Memoire: " + AbstractPath.countAllAbstractPaths());
            if (pathsForThisZ.size() < 2 && this.protection_) {
                System.out.println("Warning: Only " + pathsForThisZ.size() + " path(s) generated for request " + z.getName());
            }
            System.out.print(".");
        }
        System.out.println("\nMain paths generated: " + nb_paths_gen);
        System.out.println("Disjoint paths generated: " + nb_paths_gen_r);
    }

    protected double shortest_path_size(AbstractEdge z) {
        DijkstraAdvanced pcc = new DijkstraAdvanced(this.g_, this.code_distance_dijkstra);
        pcc.valuateFromSource(z.getAbstractVertices()[0]);
        return pcc.getDistanceTo(z.getAbstractVertices()[1]);
    }

    protected void addPath(AbstractEdge z, int nb, boolean cumul_edges, HashMap chemins) {
        int nb_chemins = 0;
        double taille_pcc = this.shortest_path_size(z);
        while (nb_chemins != nb) {
            AbstractVertex start = z.getAbstractVertices()[0];
            AbstractVertex end = z.getAbstractVertices()[1];
            AbstractVertex current = start;
            int cpt = 0;
            Vector<AbstractVertex> pathNodes = new Vector<AbstractVertex>();
            Vector<AbstractEdge> pathEdges = new Vector<AbstractEdge>();
            pathNodes.add(start);
            boolean blocked = false;
            while (current != end && pathEdges.size() <= (int)taille_pcc + this.stretch_factor && !blocked) {
                MascoptFixedSet out = current.getOutgoing(this.g_);
                AbstractEdge e = null;
                Iterator itE = out.iterator();
                if (out.size() != 0) {
                    int choix = this.generateur.nextInt(out.size());
                    for (int i = 0; i <= choix; ++i) {
                        e = (AbstractEdge)itE.next();
                    }
                    AbstractVertex v_via_e = current.getConnected(e);
                    if (!pathNodes.contains(v_via_e)) {
                        pathEdges.add(e);
                        pathNodes.add(v_via_e);
                        current = v_via_e;
                    } else {
                        int position = pathNodes.lastIndexOf(v_via_e);
                        pathNodes.setSize(position + 1);
                        pathEdges.setSize(position);
                        current = (AbstractVertex)pathNodes.elementAt(position);
                    }
                } else {
                    blocked = true;
                }
                if (++cpt != this.MAXSIZE) continue;
                blocked = true;
            }
            if (current != end) continue;
            ++nb_chemins;
            AbstractPath p = this.g_.getFactory().newAbstractPath(this.original_graph.getAbstractEdgeSet());
            Iterator itVec = pathEdges.iterator();
            while (itVec.hasNext()) {
                AbstractEdge e = (AbstractEdge)itVec.next();
                p.concatAbstractEdge(e);
            }
            System.out.println("path: " + p);
            if (chemins.get(p.toString()) != null) {
                p.free();
                continue;
            }
            chemins.put(p.toString(), p);
            if (!cumul_edges) continue;
            this.edge_for_this_set_of_paths.addAll(p.getAbstractEdgeSet());
        }
    }
}

