/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algos.abstractalgos;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractEdgeSet;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.AbstractVertexSet;
import mascoptLib.abstractGraph.MascoptFixedSet;

public class PrimMST {
    private static final int MAXEDGE = Integer.MAX_VALUE;
    private AbstractGraph G = null;
    private AbstractEdgeSet mst = null;
    private HashMap mstValues = null;
    private HashMap mstEdgeSets = null;

    public PrimMST(AbstractGraph g) {
        this.G = g;
        this.mstValues = new HashMap();
        this.mstEdgeSets = new HashMap();
    }

    private void mstWithType(String entryType) {
        AbstractVertexSet S = null;
        AbstractEdgeSet E = null;
        AbstractEdgeSet MST = null;
        AbstractEdge bestEdge = null;
        AbstractVertex bestNode = null;
        Object tempES = null;
        int distSV = Integer.MAX_VALUE;
        int weight = Integer.MAX_VALUE;
        double mstSize = 0.0;
        AbstractVertexSet V = this.G.getFactory().newAbstractVertexSet(this.G.getAbstractVertexSet());
        V.addAll((Collection)this.G.getAbstractVertexSet());
        E = this.G.getFactory().newAbstractEdgeSet(this.G.getAbstractVertexSet());
        E.addAll(this.G.getAbstractEdgeSet());
        S = this.G.getFactory().newAbstractVertexSet();
        MST = E.getFactory().newAbstractEdgeSet(this.G.getAbstractVertexSet());
        Iterator itV = V.iterator();
        while (itV.hasNext()) {
            distSV = Integer.MAX_VALUE;
            weight = Integer.MAX_VALUE;
            Iterator itS = S.iterator();
            while (itS.hasNext()) {
                AbstractVertex currentInS = (AbstractVertex)itS.next();
                MascoptFixedSet neighbors = currentInS.getNeighbours(E);
                Iterator itNeighbors = neighbors.iterator();
                while (itNeighbors.hasNext()) {
                    AbstractVertex neighborInV = (AbstractVertex)itNeighbors.next();
                    MascoptFixedSet currentSV = currentInS.getEdgesTo(E, neighborInV);
                    Iterator itEdgesSV = currentSV.iterator();
                    while (itEdgesSV.hasNext()) {
                        AbstractEdge tmp = (AbstractEdge)itEdgesSV.next();
                        try {
                            weight = Integer.parseInt(tmp.getValue(entryType));
                        }
                        catch (Exception e) {
                            weight = Integer.MAX_VALUE;
                        }
                        if (weight >= distSV) continue;
                        distSV = weight;
                        bestNode = neighborInV;
                        bestEdge = tmp;
                    }
                }
            }
            if (weight == Integer.MAX_VALUE) {
                bestNode = (AbstractVertex)itV.next();
                S.add(bestNode);
                V.remove(bestNode);
                itV = V.iterator();
                continue;
            }
            itS = S.iterator();
            while (itS.hasNext()) {
                AbstractEdge tmpE;
                AbstractVertex tmpN = (AbstractVertex)itS.next();
                MascoptFixedSet tmpES = tmpN.getEdgesTo(E, bestNode);
                Iterator itES = tmpES.iterator();
                while (itES.hasNext()) {
                    tmpE = (AbstractEdge)itES.next();
                    E.remove(tmpE);
                }
                tmpES = bestNode.getEdgesTo(E, tmpN);
                itES = tmpES.iterator();
                while (itES.hasNext()) {
                    tmpE = (AbstractEdge)itES.next();
                    E.remove(tmpE);
                }
            }
            S.add(bestNode);
            mstSize += (double)weight;
            V.remove(bestNode);
            MST.add(bestEdge);
            itV = V.iterator();
        }
        MST.free();
        if (this.mstValues.containsKey(entryType)) {
            this.mstValues.remove(entryType);
        }
        this.mstValues.put(entryType, new Double(mstSize));
        if (this.mstEdgeSets.containsKey(entryType)) {
            this.mstEdgeSets.remove(entryType);
        }
        this.mstEdgeSets.put(entryType, MST);
    }

    public Double getMSTSize(String entryType) {
        if (!this.mstValues.containsKey(entryType)) {
            this.mstWithType(entryType);
        }
        return (Double)this.mstValues.get(entryType);
    }

    public Iterator getMstEdgeSetIterator(String entryType) {
        if (!this.mstEdgeSets.containsKey(entryType)) {
            this.mstWithType(entryType);
        }
        return ((AbstractEdgeSet)this.mstEdgeSets.get(entryType)).iterator();
    }

    public Iterator computeMST(String entryType) {
        this.mstWithType(entryType);
        return ((AbstractEdgeSet)this.mstEdgeSets.get(entryType)).iterator();
    }
}

