/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algos.digraph;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mascoptLib.algos.abstractalgos.DijkstraAdvanced;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.ArcSet;
import mascoptLib.graphs.DiGraph;
import mascoptLib.graphs.DiPath;
import mascoptLib.graphs.Vertex;
import mascoptLib.util.Pair;

public class KShortestPaths {
    public static String NAME_OF_VALUE = "distance";
    private DiGraph g_ = null;
    private int k_ = 1;
    private Vector K = null;
    public int numberOfComputedPaths = 0;
    private Vector Weights = null;

    public KShortestPaths(DiGraph g, int k) {
        this.g_ = g;
        this.k_ = k;
    }

    public void run(Vertex s, Vertex t) {
        int k = 1;
        Vector<Pair> S = new Vector<Pair>();
        TreeMap<Double, DiPath> X = new TreeMap<Double, DiPath>();
        this.Weights = new Vector();
        this.K = new Vector();
        this.numberOfComputedPaths = 0;
        DiGraph g_prime = this.duplicateG(this.g_);
        DijkstraAdvanced dijkstra = new DijkstraAdvanced(g_prime, NAME_OF_VALUE);
        dijkstra.valuateFromSource(s);
        DiPath p = (DiPath)dijkstra.getShortestPathTo(t);
        if (p == null) {
            return;
        }
        p.free();
        S.add(new Pair(p, s));
        X.put(this.getLength(p), p);
        this.K.add(p);
        ++this.numberOfComputedPaths;
        this.Weights.add(this.getLength(p));
        while (k < this.k_ && !X.isEmpty()) {
            Vertex w;
            Double weight = (Double)X.firstKey();
            X.remove(weight);
            Vertex v = w = this.getDeviationVertex(S, p);
            while (v != t) {
                this.disableVerticesAndEdges(g_prime, s, v, this.K, p);
                DiPath q = new DiPath(this.g_.getArcSet());
                Vertex u = s;
                while (u != v) {
                    Arc arc = p.nextArc(u);
                    q.concat(arc);
                    u = p.nextVertex(u);
                }
                dijkstra.valuateFromSource(v);
                DiPath spd = (DiPath)dijkstra.getShortestPathTo(t);
                if (spd != null) {
                    spd.free();
                    q.concat(spd);
                    spd = null;
                    X.put(this.getLength(q), q);
                    S.add(new Pair(q, v));
                }
                v = p.nextVertex(v);
            }
            if (X.isEmpty()) continue;
            Double the_weight = (Double)X.firstKey();
            p = (DiPath)X.get(the_weight);
            this.K.add(p);
            this.Weights.add(the_weight);
            ++this.numberOfComputedPaths;
            ++k;
        }
    }

    public DiPath getShortestPath(int k) {
        if (k >= this.K.size()) {
            return null;
        }
        return (DiPath)this.K.elementAt(k);
    }

    public int numberOfComputedPaths() {
        return this.numberOfComputedPaths;
    }

    public void printComputedPaths() {
        Iterator it_path = this.K.iterator();
        int i = 0;
        while (it_path.hasNext()) {
            DiPath p = (DiPath)it_path.next();
            System.out.println("Path " + i + " of weight " + this.getWeight(i) + ": " + p);
            ++i;
        }
        if (i < this.k_) {
            System.out.println("No more paths !");
        }
    }

    public double getWeight(int k) {
        return (Double)this.Weights.elementAt(k);
    }

    private Vertex getDeviationVertex(Vector S, DiPath p) {
        Vertex w = null;
        Iterator it_s = S.iterator();
        while (it_s.hasNext() && w == null) {
            Pair pair = (Pair)it_s.next();
            DiPath p_in_s = (DiPath)pair.getKey();
            if (!this.comparePaths(p_in_s, p)) continue;
            w = (Vertex)pair.getValue();
        }
        return w;
    }

    private boolean comparePaths(DiPath p1, DiPath p2) {
        ArcSet as1 = p1.getArcSet();
        ArcSet as2 = p2.getArcSet();
        if (as1.size() != as2.size()) {
            return false;
        }
        return as1.containsAll((Collection)as2);
    }

    private boolean comparePaths(DiPath p1, DiPath p2, Vertex s, Vertex t) {
        boolean ok = true;
        Vertex v1 = s;
        Vertex v2 = s;
        while (v1 != t && ok) {
            if ((v1 = p1.nextVertex(v1)) == (v2 = p2.nextVertex(v2)) && v1 != null && v2 != null) continue;
            ok = false;
        }
        return ok;
    }

    private void disableVerticesAndEdges(DiGraph g_prime, Vertex s, Vertex v, Collection K, DiPath p) {
        g_prime.getVertexSet().addAll((Collection)this.g_.getVertexSet());
        g_prime.getArcSet().addAll(this.g_.getArcSet());
        Vertex cur = s;
        while (cur != v) {
            g_prime.getVertexSet().remove(cur);
            cur = p.nextVertex(cur);
        }
        Iterator it_k = K.iterator();
        while (it_k.hasNext()) {
            DiPath path_from_k = (DiPath)it_k.next();
            if (!this.comparePaths(p, path_from_k, s, v)) continue;
            g_prime.getAbstractEdgeSet().remove(path_from_k.nextArc(v));
        }
    }

    private DiGraph duplicateG(DiGraph g) {
        DiGraph g_prime = new DiGraph(g);
        g_prime.getAbstractVertexSet().addAll((Collection)g.getAbstractVertexSet());
        g_prime.getAbstractEdgeSet().addAll(g.getAbstractEdgeSet());
        Iterator it_edge = g.getAbstractEdgeSet().iterator();
        while (it_edge.hasNext()) {
            Arc arc = (Arc)it_edge.next();
            arc.setDoubleValue(NAME_OF_VALUE, g_prime, arc.getDoubleValue(NAME_OF_VALUE, g));
        }
        return g_prime;
    }

    private Double getLength(DiPath p) {
        double length = 0.0;
        Iterator it_edge = p.getAbstractEdgeSet().iterator();
        while (it_edge.hasNext()) {
            Arc arc = (Arc)it_edge.next();
            length += arc.getDouValue(NAME_OF_VALUE, this.g_);
        }
        return new Double(length);
    }
}

