/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algos.digraph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.MascoptFixedSet;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.ArcSet;
import mascoptLib.graphs.DiGraph;
import mascoptLib.graphs.Vertex;
import mascoptLib.graphs.VertexSet;

public class MinCut {
    private DiGraph g_;
    private Vertex s_;
    private Vertex t_;
    private HashMap label;
    private HashMap flow;
    public double INFINITY = Double.MAX_VALUE;
    public String CAPACITY = "capacity";
    private LinkedList scan;
    private double cutValue = 0.0;
    private ArcSet cutArc = new ArcSet();
    private VertexSet cutNode = new VertexSet();

    public MinCut(DiGraph g, Vertex s, Vertex t) {
        this.g_ = g;
        this.s_ = s;
        this.t_ = t;
        this.s_.setDouValue("value", this.INFINITY);
        this.label = new HashMap();
        this.label.put(this.s_, null);
        this.flow = new HashMap();
        this.scan = new LinkedList();
        this.scan.add(this.s_);
        ArcSet arcs = this.g_.getArcSet();
        Iterator itarcs = arcs.iterator();
        while (itarcs.hasNext()) {
            Arc curarc = (Arc)itarcs.next();
            this.flow.put(curarc, new Double(0.0));
        }
    }

    public void run() {
        while (this.scan.size() > 0) {
            double delta;
            double valcurnode;
            Vertex origNode;
            double Xij;
            Vertex currentNode = (Vertex)this.scan.getFirst();
            MascoptFixedSet ain = currentNode.getIncoming(this.g_);
            MascoptFixedSet aout = currentNode.getOutgoing(this.g_);
            Iterator itarcin = ain.iterator();
            Iterator itarcout = aout.iterator();
            while (itarcin.hasNext()) {
                Arc arcin = (Arc)itarcin.next();
                Xij = (Double)this.flow.get(arcin);
                origNode = (Vertex)arcin.getTail();
                if (!(Xij > 0.0) || this.label.containsKey(origNode)) continue;
                valcurnode = currentNode.getDouValue("value");
                delta = Math.min(Math.abs(valcurnode), (Double)this.flow.get(arcin));
                origNode.setDouValue("value", -1.0 * delta);
                this.label.put(origNode, currentNode);
                this.scan.add(origNode);
            }
            while (itarcout.hasNext()) {
                Arc arcout = (Arc)itarcout.next();
                Xij = (Double)this.flow.get(arcout);
                double rescap = arcout.getDouValue(this.CAPACITY) - Xij;
                origNode = (Vertex)arcout.getHead();
                if (!(rescap > 0.0) || this.label.containsKey(origNode)) continue;
                valcurnode = currentNode.getDouValue("value");
                delta = Math.min(Math.abs(valcurnode), rescap);
                origNode.setDouValue("value", delta);
                this.label.put(origNode, currentNode);
                this.scan.add(origNode);
            }
            this.scan.remove(currentNode);
            if (!this.scan.contains(this.t_)) continue;
            Vertex endNode = this.t_;
            delta = endNode.getDouValue("value");
            while (!endNode.equals(this.s_)) {
                Double valflowd;
                double valflow;
                Arc aij;
                Iterator itarc;
                MascoptFixedSet arcrecup;
                origNode = (Vertex)this.label.get(endNode);
                double signeNode = endNode.getDouValue("value");
                if (signeNode > 0.0) {
                    arcrecup = origNode.getEdgesTo(this.g_, (AbstractVertex)endNode);
                    itarc = arcrecup.iterator();
                    while (itarc.hasNext()) {
                        aij = (Arc)itarc.next();
                        valflow = (Double)this.flow.get(aij) + delta;
                        valflowd = new Double(valflow);
                        this.flow.put(aij, valflowd);
                    }
                } else {
                    arcrecup = endNode.getEdgesTo(this.g_, (AbstractVertex)origNode);
                    itarc = arcrecup.iterator();
                    while (itarc.hasNext()) {
                        aij = (Arc)itarc.next();
                        valflow = (Double)this.flow.get(aij) - delta;
                        valflowd = new Double(valflow);
                        this.flow.put(aij, valflowd);
                    }
                }
                endNode = origNode;
            }
            this.s_.setDouValue("value", this.INFINITY);
            this.label.clear();
            this.label.put(this.s_, null);
            this.scan.clear();
            this.scan.add(this.s_);
        }
    }

    public VertexSet vertexSetCutMin() {
        VertexSet noderesult = new VertexSet();
        if (this.cutNode.isEmpty()) {
            Iterator nodesIt = this.label.keySet().iterator();
            while (nodesIt.hasNext()) {
                Vertex nlabel = (Vertex)nodesIt.next();
                this.cutNode.add(nlabel);
            }
        }
        return this.cutNode;
    }

    public ArcSet arcSetCutMin() {
        if (this.cutArc.isEmpty()) {
            Iterator nodesIt = this.label.keySet().iterator();
            while (nodesIt.hasNext()) {
                Vertex nlabel = (Vertex)nodesIt.next();
                MascoptFixedSet aout = nlabel.getOutgoing(this.g_);
                Iterator itarcout = aout.iterator();
                while (itarcout.hasNext()) {
                    Arc arcout = (Arc)itarcout.next();
                    Vertex nnext = (Vertex)arcout.getHead();
                    if (this.label.containsKey(nnext)) continue;
                    this.cutArc.add(arcout);
                    this.cutValue += arcout.getDouValue(this.CAPACITY);
                }
            }
        }
        return this.cutArc;
    }

    public double minCutValue() {
        if (this.cutValue == 0.0) {
            this.cutArc = this.arcSetCutMin();
        }
        return this.cutValue;
    }

    public HashMap maxFlow() {
        return this.flow;
    }
}

