/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algos.graph;

import java.util.Iterator;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.MascoptFixedSet;
import mascoptLib.graphs.Edge;
import mascoptLib.graphs.EdgeSet;
import mascoptLib.graphs.Graph;
import mascoptLib.graphs.Vertex;
import mascoptLib.graphs.VertexSet;

public class PrimMSTSimple {
    public Graph computeMST(Graph inputGraph) {
        VertexSet touchedNodes = new VertexSet();
        EdgeSet keptEdges = new EdgeSet(touchedNodes);
        Iterator itGN = inputGraph.getVertexSet().iterator();
        if (itGN.hasNext()) {
            touchedNodes.add((Vertex)itGN.next());
        }
        while (touchedNodes.size() < inputGraph.getVertexSet().size()) {
            Iterator itTN = touchedNodes.iterator();
            int minLength = Integer.MAX_VALUE;
            Edge bestCandidate = null;
            Vertex neighborToAdd = null;
            while (itTN.hasNext()) {
                Vertex current = (Vertex)itTN.next();
                MascoptFixedSet neighbors = current.getNeighbours(inputGraph);
                Iterator itN = neighbors.iterator();
                while (itN.hasNext()) {
                    Vertex currentNeighbor = (Vertex)itN.next();
                    if (touchedNodes.contains(currentNeighbor)) continue;
                    MascoptFixedSet potentialMSTEdges = current.getEdgesTo(inputGraph, (AbstractVertex)currentNeighbor);
                    Iterator itpMSTe = potentialMSTEdges.iterator();
                    Edge potentialEdge = null;
                    while (itpMSTe.hasNext()) {
                        potentialEdge = (Edge)itpMSTe.next();
                        if (Integer.parseInt(potentialEdge.getValue("length")) >= minLength) continue;
                        minLength = Integer.parseInt(potentialEdge.getValue("length"));
                        bestCandidate = potentialEdge;
                        neighborToAdd = currentNeighbor;
                    }
                }
            }
            touchedNodes.add(neighborToAdd);
            keptEdges.add(bestCandidate);
        }
        return new Graph(touchedNodes, keptEdges);
    }
}

