/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algos.graph;

import java.util.Iterator;
import mascoptLib.abstractGraph.MascoptFixedSet;
import mascoptLib.algos.digraph.MinCut;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.ArcSet;
import mascoptLib.graphs.DiGraph;
import mascoptLib.graphs.Edge;
import mascoptLib.graphs.EdgeSet;
import mascoptLib.graphs.Graph;
import mascoptLib.graphs.Vertex;
import mascoptLib.graphs.VertexSet;

public class STMinCut {
    private Graph g_;
    private Vertex s_;
    private Vertex t_;
    private EdgeSet es;
    private VertexSet ns;
    private VertexSet nodecutmin;
    private EdgeSet edgecutmin;
    public String CAPACITY;
    public double INFINITY;

    public STMinCut(Graph g, Vertex s, Vertex t) {
        this.edgecutmin = new EdgeSet(this.ns);
        this.CAPACITY = "capacity";
        this.INFINITY = Double.MAX_VALUE;
        this.g_ = g;
        this.s_ = s;
        this.t_ = t;
        this.es = this.g_.getEdgeSet();
        this.ns = this.g_.getVertexSet();
    }

    private DiGraph orientation() {
        VertexSet Vd = this.g_.getVertexSet();
        ArcSet Ad = new ArcSet(Vd);
        DiGraph Gd = new DiGraph(Vd, Ad);
        Iterator ites = this.es.iterator();
        while (ites.hasNext()) {
            Edge currentEdge = (Edge)ites.next();
            Vertex[] ext = currentEdge.getVertices();
            Arc forward = new Arc(ext[0], ext[1]);
            double cap = currentEdge.getDouValue(this.CAPACITY);
            forward.setDouValue(this.CAPACITY, cap);
            Arc backward = new Arc(ext[1], ext[0]);
            backward.setDouValue(this.CAPACITY, cap);
            Ad.add(forward);
            Ad.add(backward);
        }
        return Gd;
    }

    public VertexSet vertexSetCutMin() {
        DiGraph diG = this.orientation();
        MinCut coupeGd = new MinCut(diG, this.s_, this.t_);
        coupeGd.CAPACITY = this.CAPACITY;
        coupeGd.INFINITY = this.INFINITY;
        coupeGd.run();
        this.nodecutmin = coupeGd.vertexSetCutMin();
        return this.nodecutmin;
    }

    public EdgeSet edgeSetCutMin() {
        if (this.nodecutmin.isEmpty()) {
            VertexSet nodec = this.vertexSetCutMin();
        }
        Iterator nodesIt = this.nodecutmin.iterator();
        while (nodesIt.hasNext()) {
            Vertex ncurrent = (Vertex)nodesIt.next();
            MascoptFixedSet esetcurrent = ncurrent.getIncidentEdges(this.g_);
            Iterator edgesIt = esetcurrent.iterator();
            while (edgesIt.hasNext()) {
                Edge ecurrent = (Edge)edgesIt.next();
                Vertex neighbour = (Vertex)ecurrent.getConnected(ncurrent);
                if (this.nodecutmin.contains(neighbour)) continue;
                this.edgecutmin.add(ecurrent);
            }
        }
        return this.edgecutmin;
    }

    public double minCutValue() {
        double value = 0.0;
        EdgeSet esmin = this.edgecutmin.isEmpty() ? this.edgeSetCutMin() : this.edgecutmin;
        Iterator itesmin = esmin.iterator();
        while (itesmin.hasNext()) {
            Edge ecur = (Edge)itesmin.next();
            value += ecur.getDouValue(this.CAPACITY);
        }
        return value;
    }
}

