/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphs;

import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractVertex;

public class Arc
extends AbstractEdge {
    private AbstractVertex tail;
    private AbstractVertex head;

    public Arc(AbstractVertex tail, AbstractVertex head) {
        super(tail, head);
        this.tail = tail;
        this.head = head;
    }

    public String toString() {
        return "[" + this.getTail() + "->" + this.getHead() + "]";
    }

    public AbstractVertex getTail() {
        return this.tail;
    }

    public AbstractVertex getHead() {
        return this.head;
    }

    public AbstractVertex getOppositeEnd(AbstractVertex vertex) {
        return this.getOppositeAbstractVertex(vertex);
    }

    public boolean leadsTo(AbstractVertex n) {
        return this.head == n;
    }

    public boolean leaves(AbstractVertex n) {
        return this.tail == n;
    }

    public AbstractVertex getConnected(AbstractVertex n) {
        if (this.tail == n) {
            return this.head;
        }
        return null;
    }

    public void reverse() {
        AbstractVertex tmp = this.tail;
        this.tail = this.head;
        this.head = tmp;
    }

    public String getDOMTagHierarchy() {
        return "LINKS";
    }

    public String getDOMTagName() {
        return "ARC";
    }
}

