/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphs;

import java.util.HashMap;
import java.util.Iterator;
import mascoptLib.abstractGraph.AbstractEdgeSet;
import mascoptLib.abstractGraph.AbstractEdgeSetFactory;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.ArcSetFactory;
import mascoptLib.graphs.Vertex;
import mascoptLib.graphs.VertexSet;

public class ArcSet
extends AbstractEdgeSet {
    private static AbstractEdgeSetFactory arcSetFactory = new ArcSetFactory();

    public ArcSet() {
    }

    public ArcSet(VertexSet nodeSet) {
        super(nodeSet);
    }

    public ArcSet(ArcSet arcSet) {
        super(arcSet);
    }

    public ArcSet(ArcSet arcSet, VertexSet nodeSet) {
        super((AbstractEdgeSet)arcSet, nodeSet);
    }

    public ArcSet(ArcSet originalSet, boolean copyElements) {
        super((AbstractEdgeSet)originalSet, copyElements);
        this.setName("Copy of set " + originalSet.getName() + " (" + originalSet.getId() + ")");
        if (originalSet != null && copyElements) {
            this.clear();
            HashMap<String, Vertex> isomorphism = new HashMap<String, Vertex>();
            Iterator itOSNS = originalSet.getVertexSet().iterator();
            Iterator itNS = null;
            block0: while (itOSNS.hasNext()) {
                itNS = this.getVertexSet().iterator();
                String osnId = ((Vertex)itOSNS.next()).getId();
                Vertex correspNode = null;
                while (itNS.hasNext()) {
                    correspNode = (Vertex)itNS.next();
                    String pattren = "^[a-zA-Z ]* id=" + osnId + "$";
                    if (!correspNode.getName().matches(pattren)) continue;
                    isomorphism.put(osnId, correspNode);
                    continue block0;
                }
            }
            Iterator itAS = originalSet.iterator();
            while (itAS.hasNext()) {
                Arc arcToCopy = (Arc)itAS.next();
                Arc newArc = new Arc((Vertex)isomorphism.get(arcToCopy.getTail().getId()), (Vertex)isomorphism.get(arcToCopy.getHead().getId()));
                newArc.copyValues(arcToCopy);
                newArc.setName("Copy of arc with id=" + arcToCopy.getId());
                this.add(newArc);
            }
        }
    }

    public AbstractEdgeSetFactory getFactory() {
        return arcSetFactory;
    }

    public boolean add(Arc o) {
        if (o instanceof Arc) {
            return super.add(o);
        }
        return false;
    }

    public boolean remove(Arc o) {
        if (o instanceof Arc) {
            return super.remove(o);
        }
        return false;
    }

    public VertexSet getVertexSet() {
        return (VertexSet)this.getAbstractVertexSet();
    }

    public String getDOMTagHierarchy() {
        return "SETS";
    }

    public String getDOMTagName() {
        return "ARC_SET";
    }
}

