/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphs;

import java.util.Iterator;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractGraphFactory;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.ArcSet;
import mascoptLib.graphs.DiGraphFactory;
import mascoptLib.graphs.Edge;
import mascoptLib.graphs.EdgeSet;
import mascoptLib.graphs.Graph;
import mascoptLib.graphs.Vertex;
import mascoptLib.graphs.VertexSet;
import mascoptLib.util.Trace;

public class DiGraph
extends AbstractGraph {
    private static AbstractGraphFactory digraphFactory = new DiGraphFactory();

    public DiGraph() {
        Trace.println("Nouveau Digraph tout vide.");
    }

    public DiGraph(VertexSet nodeSet, ArcSet arcSet) {
        super(nodeSet, arcSet);
        Trace.println("nouveau digraph de " + nodeSet + " " + arcSet);
    }

    public DiGraph(DiGraph digraph) {
        super(digraph);
        Trace.println("nouveau digraph sous-graphe de " + digraph);
    }

    public DiGraph(DiGraph graph, boolean copyElements) {
        super(graph, copyElements);
        if (copyElements) {
            Trace.println("nouveau digraph copie de " + graph);
        } else {
            Trace.println("nouveau digraph sous-graphe de " + graph);
        }
    }

    public String toString() {
        return "DiGraph V=" + this.getVertexSet() + " E=" + this.getArcSet();
    }

    public AbstractGraphFactory getFactory() {
        return digraphFactory;
    }

    public VertexSet getVertexSet() {
        return (VertexSet)this.getAbstractVertexSet();
    }

    public boolean setVertexSet(VertexSet nodeSet) {
        return this.setAbstractVertexSet(nodeSet);
    }

    public ArcSet getArcSet() {
        return (ArcSet)this.getAbstractEdgeSet();
    }

    public boolean setArcSet(ArcSet arcSet) {
        return this.setAbstractEdgeSet(arcSet);
    }

    public void replace(Vertex node, DiGraph g) {
        super.replace((AbstractVertex)node, g);
    }

    public void replace(Vertex node, VertexSet nodeSet) {
        super.replace((AbstractVertex)node, nodeSet);
    }

    public DiGraph copyDiGraph() {
        return (DiGraph)super.copyAbstractGraph();
    }

    public Graph constructGraph() {
        VertexSet ns = this.getVertexSet();
        ArcSet as = this.getArcSet();
        EdgeSet es = new EdgeSet(ns);
        Iterator itas = as.iterator();
        while (itas.hasNext()) {
            Arc arc = (Arc)itas.next();
            es.add(new Edge((Vertex)arc.getTail(), (Vertex)arc.getHead()));
        }
        Graph G = new Graph(ns, es);
        return G;
    }

    public String getDOMTagHierarchy() {
        return "GRAPHS";
    }

    public String getDOMTagName() {
        return "DIGRAPH";
    }
}

