/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphs;

import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractEdgeSet;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractGraphFactory;
import mascoptLib.abstractGraph.AbstractGraphSet;
import mascoptLib.abstractGraph.AbstractPath;
import mascoptLib.abstractGraph.AbstractPathSet;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.AbstractVertexSet;
import mascoptLib.graphs.ArcSet;
import mascoptLib.graphs.ArcSetFactory;
import mascoptLib.graphs.DiGraph;
import mascoptLib.graphs.DiGraphSet;
import mascoptLib.graphs.DiPath;
import mascoptLib.graphs.DiPathSet;
import mascoptLib.graphs.VertexSet;
import mascoptLib.graphs.VertexSetFactory;

public class DiGraphFactory
implements AbstractGraphFactory {
    static VertexSetFactory vsf = new VertexSetFactory();
    static ArcSetFactory asf = new ArcSetFactory();

    public AbstractGraph newAbstractGraph(AbstractVertexSet nodeSet, AbstractEdgeSet edgeSet) {
        return new DiGraph((VertexSet)nodeSet, (ArcSet)edgeSet);
    }

    public AbstractGraph newAbstractGraph(AbstractGraph graph) {
        return new DiGraph((DiGraph)graph);
    }

    public AbstractGraph newAbstractCopyGraph(AbstractGraph graph, boolean copyElements) {
        return new DiGraph((DiGraph)graph, copyElements);
    }

    public AbstractVertexSet newAbstractVertexSet() {
        return vsf.newAbstractVertexSet();
    }

    public AbstractVertexSet newAbstractVertexSet(AbstractVertexSet nodeSet) {
        return vsf.newAbstractVertexSet(nodeSet);
    }

    public AbstractVertex newAbstractVertex() {
        return vsf.newAbstractVertex();
    }

    public AbstractEdgeSet newAbstractEdgeSet(AbstractVertexSet nodeSet) {
        return asf.newAbstractEdgeSet(nodeSet);
    }

    public AbstractEdgeSet newAbstractEdgeSet(AbstractEdgeSet edgeSet) {
        return asf.newAbstractEdgeSet(edgeSet);
    }

    public AbstractEdgeSet newAbstractEdgeSet(AbstractEdgeSet es, AbstractVertexSet abstractNodeSet) {
        return asf.newAbstractEdgeSet(es, abstractNodeSet);
    }

    public AbstractEdge newAbstractEdge(AbstractVertex n0, AbstractVertex n1) {
        return asf.newAbstractEdge(n0, n1);
    }

    public AbstractPath newAbstractPath(AbstractEdgeSet edgeSet) {
        return asf.newAbstractPath(edgeSet);
    }

    public AbstractPath newAbstractCopyPath(AbstractPath chain) {
        return new DiPath((DiPath)chain);
    }

    public AbstractGraphSet newAbstractGraphSet() {
        return new DiGraphSet();
    }

    public AbstractPathSet newAbstractPathSet() {
        return new DiPathSet();
    }
}

