/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphs;

import mascoptLib.abstractGraph.AbstractGraphFactory;
import mascoptLib.abstractGraph.AbstractPath;
import mascoptLib.abstractGraph.MascoptFixedSet;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.ArcSet;
import mascoptLib.graphs.DiGraphFactory;
import mascoptLib.graphs.Vertex;
import mascoptLib.graphs.VertexSet;
import mascoptLib.util.Trace;

public class DiPath
extends AbstractPath {
    private static AbstractGraphFactory digraphFactory = new DiGraphFactory();

    public DiPath(ArcSet arcSet) {
        super(arcSet);
    }

    public DiPath(DiPath path) {
        super(path);
    }

    public String toString() {
        if (this.getStart() == null) {
            return "null";
        }
        if (this.isMulti()) {
            return "multi-path (hard to display)";
        }
        String name = "" + this.getStart();
        Vertex tmp = this.nextVertex(this.getStart());
        while (tmp != this.getEnd()) {
            name = name + "->" + tmp;
            tmp = this.nextVertex(tmp);
        }
        name = name + "->" + this.end;
        return name;
    }

    public AbstractGraphFactory getFactory() {
        return digraphFactory;
    }

    public boolean concat(Arc arc) {
        Trace.println("Arc.concat(" + arc + ")");
        if (this.getStart() == null) {
            Trace.println("on initialise");
            this.init(arc.getTail(), arc.getHead(), arc);
            return true;
        }
        return this.concatAbstractEdge(arc);
    }

    public boolean concat(DiPath path) {
        if (this.getEnd() == path.getStart() || this.getStart() == path.getEnd() || this.getStart() == null) {
            return this.concatAbstractPath(path);
        }
        Trace.printErrln("On ne peut pas concatener");
        return false;
    }

    public boolean merge(DiPath path) {
        if (this.getStart() == path.getStart() && this.getEnd() == path.getEnd()) {
            return this.mergeAbstractPath(path);
        }
        Trace.printErrln("Path merge error");
        return false;
    }

    public ArcSet getArcSet() {
        return (ArcSet)this.getAbstractEdgeSet();
    }

    public VertexSet getVertexSet() {
        return (VertexSet)this.getAbstractVertexSet();
    }

    public Vertex getStart() {
        return (Vertex)this.getAbstractStart();
    }

    public Vertex getEnd() {
        return (Vertex)this.getAbstractEnd();
    }

    public Vertex nextVertex(Vertex node) {
        return (Vertex)this.nextAbstractVertex(node);
    }

    public Arc nextArc(Vertex node) {
        return (Arc)this.nextAbstractEdge(node);
    }

    public MascoptFixedSet nextArcSet(Vertex node) {
        return this.nextAbstractEdgeSet(node);
    }

    public MascoptFixedSet predArcSet(Vertex node) {
        return this.predAbstractEdgeSet(node);
    }

    public String getDOMTagHierarchy() {
        return "PATHS";
    }

    public String getDOMTagName() {
        return "DIPATH";
    }
}

