/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphs;

import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractEdgeSet;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractGraphFactory;
import mascoptLib.abstractGraph.AbstractGraphSet;
import mascoptLib.abstractGraph.AbstractPath;
import mascoptLib.abstractGraph.AbstractPathSet;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.AbstractVertexSet;
import mascoptLib.graphs.EdgeSet;
import mascoptLib.graphs.EdgeSetFactory;
import mascoptLib.graphs.Graph;
import mascoptLib.graphs.GraphSet;
import mascoptLib.graphs.Path;
import mascoptLib.graphs.PathSet;
import mascoptLib.graphs.VertexSet;
import mascoptLib.graphs.VertexSetFactory;

public class GraphFactory
implements AbstractGraphFactory {
    static VertexSetFactory vsf = new VertexSetFactory();
    static EdgeSetFactory esf = new EdgeSetFactory();

    public AbstractGraph newAbstractGraph(AbstractVertexSet nodeSet, AbstractEdgeSet edgeSet) {
        return new Graph((VertexSet)nodeSet, (EdgeSet)edgeSet);
    }

    public AbstractGraph newAbstractGraph(AbstractGraph graph) {
        return new Graph((Graph)graph);
    }

    public AbstractGraph newAbstractCopyGraph(AbstractGraph graph, boolean copyElements) {
        return new Graph((Graph)graph, copyElements);
    }

    public AbstractVertexSet newAbstractVertexSet() {
        return vsf.newAbstractVertexSet();
    }

    public AbstractVertexSet newAbstractVertexSet(AbstractVertexSet nodeSet) {
        return vsf.newAbstractVertexSet(nodeSet);
    }

    public AbstractVertex newAbstractVertex() {
        return vsf.newAbstractVertex();
    }

    public AbstractEdgeSet newAbstractEdgeSet(AbstractVertexSet nodeSet) {
        return esf.newAbstractEdgeSet(nodeSet);
    }

    public AbstractEdgeSet newAbstractEdgeSet(AbstractEdgeSet edgeSet) {
        return esf.newAbstractEdgeSet(edgeSet);
    }

    public AbstractEdgeSet newAbstractEdgeSet(AbstractEdgeSet es, AbstractVertexSet abstractNodeSet) {
        return esf.newAbstractEdgeSet(es, abstractNodeSet);
    }

    public AbstractEdge newAbstractEdge(AbstractVertex n0, AbstractVertex n1) {
        return esf.newAbstractEdge(n0, n1);
    }

    public AbstractPath newAbstractPath(AbstractEdgeSet edgeSet) {
        return esf.newAbstractPath(edgeSet);
    }

    public AbstractPath newAbstractCopyPath(AbstractPath chain) {
        return new Path((Path)chain);
    }

    public AbstractGraphSet newAbstractGraphSet() {
        return new GraphSet();
    }

    public AbstractPathSet newAbstractPathSet() {
        return new PathSet();
    }
}

