/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphs;

import java.util.Iterator;
import mascoptLib.abstractGraph.AbstractGraphFactory;
import mascoptLib.abstractGraph.AbstractPath;
import mascoptLib.abstractGraph.MascoptFixedSet;
import mascoptLib.graphs.Edge;
import mascoptLib.graphs.EdgeSet;
import mascoptLib.graphs.GraphFactory;
import mascoptLib.graphs.Vertex;
import mascoptLib.graphs.VertexSet;
import mascoptLib.util.Trace;
import mascoptLib.util.exception.MascoptImpossibleOperationPathException;

public class Path
extends AbstractPath {
    private static AbstractGraphFactory graphFactory = new GraphFactory();

    public Path(EdgeSet edgeSet) {
        super(edgeSet);
    }

    public Path(Path chain) {
        super(chain);
    }

    public String toString() {
        if (this.isMulti()) {
            return "multi-chain (hard to display)";
        }
        String name = "" + this.getStart();
        MascoptFixedSet es = this.nextEdgeSet(this.getStart());
        Edge out = null;
        Vertex tmp = this.getStart();
        while (tmp != this.getEnd()) {
            es = this.nextEdgeSet(tmp);
            Iterator it_es = es.iterator();
            Edge out2 = (Edge)it_es.next();
            if (out2 == out) {
                out2 = (Edge)it_es.next();
            }
            out = out2;
            tmp = (Vertex)out2.getConnected(tmp);
            name = name + "-" + tmp;
        }
        name = name + "-" + this.end;
        return name;
    }

    public AbstractGraphFactory getFactory() {
        return graphFactory;
    }

    public boolean concat(Edge edge) {
        if (this.getStart() == null) {
            Trace.println("on initialise");
            Vertex[] nodes = edge.getVertices();
            this.init(nodes[0], nodes[1], edge);
            return true;
        }
        return this.concatAbstractEdge(edge);
    }

    public boolean concat(Path chain) {
        if (this.concatAbstractPath(chain)) {
            return true;
        }
        Trace.printErrln("On ne peut pas concatener");
        return false;
    }

    public boolean merge(Path chain) {
        if (this.mergeAbstractPath(chain)) {
            return true;
        }
        Trace.printErrln("Chain merge error");
        return false;
    }

    public EdgeSet getEdgeSet() {
        return (EdgeSet)this.getAbstractEdgeSet();
    }

    public VertexSet getVertexSet() {
        return (VertexSet)this.getAbstractVertexSet();
    }

    public Vertex getStart() {
        return (Vertex)this.getAbstractStart();
    }

    public Vertex getEnd() {
        return (Vertex)this.getAbstractEnd();
    }

    public Vertex nextVertex(Vertex node) {
        throw new MascoptImpossibleOperationPathException("There is two possibilities to exit the vertex " + node + " and we cannot choose what edge to return.");
    }

    public Edge nextEdge(Vertex node) {
        throw new MascoptImpossibleOperationPathException("There is two possibilities to exit the vertex " + node + " and we cannot choose what edge to return.");
    }

    public MascoptFixedSet nextEdgeSet(Vertex node) {
        return this.nextAbstractEdgeSet(node);
    }

    public MascoptFixedSet predEdgeSet(Vertex node) {
        return this.predAbstractEdgeSet(node);
    }

    public String getDOMTagHierarchy() {
        return "PATHS";
    }

    public String getDOMTagName() {
        return "PATH";
    }
}

