/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.MascoptObject;
import mascoptLib.graphs.Vertex;
import mascoptLib.gui.GArc;
import mascoptLib.gui.GLayer;
import mascoptLib.gui.GVertex;
import mascoptLib.gui.GView;
import mascoptLib.gui.RightButtonListener;
import mascoptLib.gui.Selectable;
import mascoptLib.gui.views.DefaultViewAdapter;
import mascoptLib.gui.views.GObject;
import mascoptLib.gui.views.Link;
import mascoptLib.gui.views.View;

class EditorListener
extends DefaultViewAdapter {
    public static int CREATE = 0;
    public static int DESTROY = 1;
    public static int SET_VALUE = 2;
    public static int SET_COLOR = 3;
    public static int SET_NAME = 4;
    private AbstractGraph ag;
    private GLayer gl;
    private GVertex startNode = null;
    private GObject endNode = null;
    private Link linkTmp = null;
    private int action = 0;
    private String oldEntry = "";
    private String oldValue = "";
    private Color oldColor = Color.white;
    private String oldName = "";
    private RightButtonListener rbl = null;

    public EditorListener() {
        this.setAction(CREATE);
    }

    public void setGraph(AbstractGraph ag) {
        this.ag = ag;
    }

    public void setLayer(GLayer gl) {
        this.gl = gl;
    }

    public void setAction(int type) {
        this.action = type;
    }

    private void newNode(int x, int y) {
        Vertex n = (Vertex)this.ag.getAbstractVertexSet().getFactory().newAbstractVertex(x, y);
        if (this.ag != null) {
            this.ag.getAbstractVertexSet().add(n);
        }
    }

    private void newArc(GVertex n0, GVertex n1) {
        if (n0 != n1) {
            AbstractEdge ae = this.ag.getAbstractEdgeSet().getFactory().newAbstractEdge(n0.getAbstractVertex(), n1.getAbstractVertex());
            if (this.ag != null) {
                this.ag.getAbstractEdgeSet().add(ae);
            }
        }
    }

    public void setRightButtonListener(RightButtonListener _rbl) {
        this.rbl = _rbl;
    }

    public void mouseClicked(MouseEvent e) {
        if (this.gl.getGGraphs().size() == 0) {
            return;
        }
        Object source = e.getSource();
        if (e.getModifiers() == 4) {
            if (this.startNode != null) {
                this.stopCreateArc();
            } else if (this.rbl != null) {
                if (source instanceof GVertex) {
                    this.rbl.nodeRightClicked(e, ((GVertex)source).getAbstractVertex());
                } else if (source instanceof GArc) {
                    this.rbl.edgeRightClicked(e, ((GArc)source).getAbstractEdge());
                }
            }
            return;
        }
        if (this.action == DESTROY) {
            if (source instanceof GVertex) {
                if (this.ag != null) {
                    this.ag.getAbstractVertexSet().remove(((GVertex)source).getAbstractVertex());
                }
            } else if (source instanceof GArc && this.ag != null) {
                this.ag.getAbstractEdgeSet().remove(((GArc)source).getAbstractEdge());
            }
            return;
        }
        if (this.action == SET_VALUE) {
            MascoptObject moi = null;
            if (source instanceof GVertex) {
                moi = ((GVertex)source).getAbstractVertex();
            } else if (source instanceof GArc) {
                moi = ((GArc)source).getAbstractEdge();
            } else {
                return;
            }
            Object[] message = new Object[3];
            JPanel jpEntry = new JPanel();
            JTextField jtfEntry = new JTextField(this.oldEntry, 10);
            jpEntry.add(new JLabel("Entry:"));
            jpEntry.add(jtfEntry);
            JPanel jpValue = new JPanel();
            JTextField jtfValue = new JTextField(this.oldValue, 10);
            jpValue.add(new JLabel("Value:"));
            jpValue.add(jtfValue);
            message[0] = new JLabel("Set Value for node " + moi.getId());
            message[1] = jpEntry;
            message[2] = jpValue;
            JOptionPane.showMessageDialog(null, message, "Info", 1);
            this.oldEntry = jtfEntry.getText();
            this.oldValue = jtfValue.getText();
            moi.setValue(this.oldEntry, this.oldValue);
            return;
        }
        if (this.action == SET_COLOR) {
            MascoptObject moi = null;
            if (source instanceof GVertex) {
                moi = ((GVertex)source).getAbstractVertex();
            } else if (source instanceof GArc) {
                moi = ((GArc)source).getAbstractEdge();
            } else {
                return;
            }
            Color newColor = JColorChooser.showDialog((GObject)e.getSource(), "Color Chooser", this.oldColor);
            if (newColor == null) {
                return;
            }
            moi.setValue("color", "" + newColor.getRGB());
            this.oldColor = newColor;
            return;
        }
        if (this.action == SET_NAME) {
            MascoptObject moi = null;
            String input = "";
            if (source instanceof GVertex) {
                moi = ((GVertex)source).getAbstractVertex();
                input = "Enter name for Node " + moi.getId();
            } else if (source instanceof GArc) {
                moi = ((GArc)source).getAbstractEdge();
                input = "Enter name for Arc " + moi.getId();
            } else if (source instanceof GView) {
                moi = this.ag;
                input = "Enter name for the Graph ";
            } else {
                return;
            }
            String val = JOptionPane.showInputDialog(input, (Object)this.oldName);
            if (val == null) {
                return;
            }
            moi.setName(val);
            this.oldName = val;
            return;
        }
        if (e.getModifiers() == 4) {
            this.stopCreateArc();
            return;
        }
        if (source instanceof View) {
            View view = (View)source;
            Point p = view.getReal(e.getPoint());
            this.newNode(p.x, p.y);
        } else if (source instanceof GVertex) {
            GVertex gNode = (GVertex)source;
            if (this.startNode == null) {
                this.startCreateArc(gNode);
            } else {
                this.newArc(this.startNode, gNode);
                this.stopCreateArc();
                this.startCreateArc(gNode);
            }
        }
    }

    private void startCreateArc(GVertex gNode) {
        this.startNode = gNode;
        this.startNode.select();
        this.endNode = new GObject(gNode.getLocation().x, gNode.getLocation().y, 1, 1);
        this.linkTmp = new Link(this.startNode, this.endNode, Color.black);
        this.linkTmp.addMouseMotionListener(this);
        this.linkTmp.addMouseListener(this);
        this.gl.add(this.linkTmp);
    }

    private void stopCreateArc() {
        if (this.startNode != null) {
            this.startNode.exit();
            this.startNode = null;
            this.gl.remove(this.endNode);
            this.endNode = null;
            this.gl.remove(this.linkTmp);
            this.linkTmp = null;
        }
    }

    public void mouseEntered(MouseEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Selectable) {
            ((Selectable)obj).enter();
        }
    }

    public void mouseExited(MouseEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Selectable) {
            ((Selectable)obj).exit();
        }
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        Object source = e.getSource();
        if (source instanceof View) {
            View view = (View)source;
            if (this.startNode != null) {
                this.endNode.setLocation(view.getReal(e.getPoint()));
                view.repaint();
            }
        } else {
            GObject go = (GObject)source;
            if (this.startNode != null) {
                Point locObj = go.getLocation();
                locObj.translate(e.getPoint().x, e.getPoint().y);
                this.endNode.setLocation(locObj);
                this.linkTmp.repaint();
            }
        }
    }

    class IntColorChooser
    extends JButton
    implements ActionListener {
        JTextField jtf;

        public IntColorChooser(JTextField jtf) {
            super("Col");
            this.jtf = jtf;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            Color newColor = JColorChooser.showDialog(this.jtf, "Color Helper", Color.white);
            this.jtf.setText("" + newColor.getRGB());
        }
    }
}

