/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.MascoptObject;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.Edge;
import mascoptLib.gui.GArc;
import mascoptLib.gui.GLayer;
import mascoptLib.gui.GVertex;
import mascoptLib.gui.Origin;
import mascoptLib.gui.views.DefaultViewAdapter;
import mascoptLib.gui.views.GObject;
import mascoptLib.util.NotifyReason;
import mascoptLib.util.Trace;

class GGraph
implements Observer {
    private Hashtable gObjects;
    private AbstractGraph graph;
    private DefaultViewAdapter vl;
    private GLayer gLayer;
    private Color nodeColor = Color.yellow;
    private Color arcColor = Color.blue;

    public GGraph(AbstractGraph graph, GLayer gl) {
        this.graph = graph;
        this.gLayer = gl;
        this.vl = gl.getDefaultViewAdapter();
        graph.getAbstractVertexSet().addAddObserver(this);
        graph.getAbstractEdgeSet().addAddObserver(this);
        graph.getAbstractVertexSet().addRemoveObserver(this);
        graph.getAbstractEdgeSet().addRemoveObserver(this);
        this.gObjects = new Hashtable();
        Iterator it = graph.getAbstractVertexSet().iterator();
        while (it.hasNext()) {
            this.addAbstractNode((AbstractVertex)it.next());
        }
        it = graph.getAbstractEdgeSet().iterator();
        while (it.hasNext()) {
            this.addAbstractEdge((AbstractEdge)it.next());
        }
        Origin o = new Origin(15, Color.black);
        this.gObjects.put("origin", o);
        this.gLayer.add(o, 0);
    }

    public AbstractGraph getGraph() {
        return this.graph;
    }

    public GLayer getLayer() {
        return this.gLayer;
    }

    public GObject getGObject(Object n) {
        return (GObject)this.gObjects.get(n);
    }

    public void remove() {
        Iterator it = this.graph.getAbstractVertexSet().iterator();
        while (it.hasNext()) {
            this.removeAbstractNode((AbstractVertex)it.next());
        }
        it = this.graph.getAbstractEdgeSet().iterator();
        while (it.hasNext()) {
            this.removeAbstractEdge((AbstractEdge)it.next());
        }
        this.gObjects = null;
        this.graph.getAbstractVertexSet().deleteAddObserver(this);
        this.graph.getAbstractEdgeSet().deleteAddObserver(this);
        this.graph.getAbstractVertexSet().deleteRemoveObserver(this);
        this.graph.getAbstractEdgeSet().deleteRemoveObserver(this);
        this.vl = null;
        this.gLayer = null;
        this.graph = null;
    }

    protected void setVisible(boolean visible) {
        Enumeration enumeration = this.gObjects.elements();
        while (enumeration.hasMoreElements()) {
            GObject go = (GObject)enumeration.nextElement();
            if (!visible) {
                this.gLayer.remove(go);
                continue;
            }
            if (this.gLayer.contains(go)) continue;
            if (go instanceof GVertex) {
                this.gLayer.add(go);
                continue;
            }
            this.gLayer.add(go, 0);
        }
    }

    private void addAbstractNode(AbstractVertex node) {
        GVertex gn = new GVertex(node, 15, 15, this.nodeColor);
        String rgb = node.getValue("color", this.graph);
        if (rgb != null) {
            gn.setColor(new Color(Integer.parseInt(rgb)));
        }
        gn.addMouseListener(this.vl);
        gn.addMouseMotionListener(this.vl);
        this.gLayer.add(gn);
        this.gObjects.put(node, gn);
        node.addValueObserver(this);
    }

    private void addAbstractEdge(AbstractEdge arc) {
        String rgb;
        AbstractVertex[] nodes = arc.getAbstractVertices();
        GVertex nS = (GVertex)this.getGObject(nodes[0]);
        GVertex nT = (GVertex)this.getGObject(nodes[1]);
        if (arc instanceof Arc) {
            nS = (GVertex)this.getGObject(((Arc)arc).getTail());
            nT = (GVertex)this.getGObject(((Arc)arc).getHead());
        }
        int h = this.gLayer.addShift(nS, nT);
        GArc ga = new GArc(nS, nT, arc, this.arcColor, h);
        if (arc instanceof Edge) {
            ga.setVisibleArrow(false);
        }
        if ((rgb = arc.getValue("color", this.graph)) != null) {
            ga.setColor(new Color(Integer.parseInt(rgb)));
        }
        ga.addMouseListener(this.vl);
        ga.addMouseMotionListener(this.vl);
        this.gLayer.add(ga, 0);
        this.gObjects.put(arc, ga);
        arc.addValueObserver(this);
    }

    private void removeAbstractNode(AbstractVertex node) {
        GVertex gn = (GVertex)this.getGObject(node);
        gn.removeMouseListener(this.vl);
        gn.removeMouseMotionListener(this.vl);
        this.gLayer.remove(gn);
        node.deleteValueObserver(this);
        this.gObjects.remove(node);
        gn.delete();
    }

    private void removeAbstractEdge(AbstractEdge arc) {
        GArc ga = (GArc)this.getGObject(arc);
        ga.removeMouseListener(this.vl);
        ga.removeMouseMotionListener(this.vl);
        this.gLayer.remove(ga);
        this.gLayer.removeShift((GVertex)ga.getSource(), (GVertex)ga.getTarget(), ga.getShift());
        arc.deleteValueObserver(this);
        this.gObjects.remove(arc);
    }

    private boolean valueInLabel(String value, String[] label) {
        if (label == null) {
            return false;
        }
        for (int i = 0; i < label.length; ++i) {
            if (label[i].indexOf("$(" + value + ")") == -1) continue;
            return true;
        }
        return false;
    }

    public void update(Observable o, Object arg) {
        if (!(arg instanceof NotifyReason)) {
            return;
        }
        NotifyReason nr = (NotifyReason)arg;
        Object[] objs = nr.getObjects();
        String message = nr.getMessage();
        if (message.equalsIgnoreCase("Add")) {
            if (objs[0] instanceof AbstractVertex) {
                this.addAbstractNode((AbstractVertex)objs[0]);
                this.gLayer.addLabel((MascoptObject)objs[0], this.graph, this.gLayer.getNodeLabel(this.graph));
            } else if (objs[0] instanceof AbstractEdge) {
                this.addAbstractEdge((AbstractEdge)objs[0]);
                this.gLayer.addLabel((MascoptObject)objs[0], this.graph, this.gLayer.getArcLabel(this.graph));
            }
            this.gLayer.repaint();
        } else if (message.equalsIgnoreCase("Remove")) {
            if (objs[0] instanceof AbstractVertex) {
                this.removeAbstractNode((AbstractVertex)objs[0]);
                this.gLayer.removeLabel((MascoptObject)objs[0], this.graph);
            } else if (objs[0] instanceof AbstractEdge) {
                this.removeAbstractEdge((AbstractEdge)objs[0]);
                this.gLayer.removeLabel((MascoptObject)objs[0], this.graph);
            }
            this.gLayer.repaint();
        } else if (message.equalsIgnoreCase("value changed")) {
            String value = (String)objs[1];
            if (objs[0] instanceof AbstractVertex) {
                String[] lines;
                AbstractVertex an = (AbstractVertex)objs[0];
                GVertex gn = (GVertex)this.getGObject(an);
                if (value.equals("x") || value.equals("y")) {
                    gn.setLocation((int)Math.round(an.getX()), (int)Math.round(an.getY()));
                    this.gLayer.repaint();
                }
                if (value.equals("color")) {
                    String colValue = an.getValue("color", this.graph);
                    if (colValue != null) {
                        gn.setColor(new Color(Integer.parseInt(colValue)));
                    } else {
                        gn.setColor(this.nodeColor);
                    }
                    this.gLayer.repaint();
                }
                if (this.valueInLabel(value, lines = this.gLayer.getNodeLabel(this.graph))) {
                    this.gLayer.updateLabel(an, this.graph, lines);
                    if (this.gLayer.updateLabelsWhenValuesChange) {
                        this.gLayer.repaint();
                    }
                }
            } else if (objs[0] instanceof AbstractEdge) {
                AbstractEdge ae = (AbstractEdge)objs[0];
                GArc ga = (GArc)this.getGObject(ae);
                if (value.equals("color")) {
                    String colValue = ae.getValue("color", this.graph);
                    if (colValue != null) {
                        ga.setColor(new Color(Integer.parseInt(colValue)));
                    } else {
                        ga.setColor(this.arcColor);
                    }
                    this.gLayer.repaint();
                } else {
                    String[] lines = this.gLayer.getArcLabel(this.graph);
                    if (this.valueInLabel(value, lines)) {
                        this.gLayer.updateLabel(ae, this.graph, lines);
                        if (this.gLayer.updateLabelsWhenValuesChange) {
                            this.gLayer.repaint();
                        }
                    }
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        Trace.println("ON FINALISE UN GGraph !!! et c cool", Trace.MEMORY);
        super.finalize();
    }
}

