/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.MascoptObject;
import mascoptLib.abstractGraph.MascoptSet;
import mascoptLib.gui.GGraph;
import mascoptLib.gui.GVertex;
import mascoptLib.gui.LabelNameVisible;
import mascoptLib.gui.views.DefaultViewAdapter;
import mascoptLib.gui.views.GObject;
import mascoptLib.gui.views.Label;
import mascoptLib.gui.views.Layer;
import mascoptLib.util.Trace;

public class GLayer
extends Layer {
    private Vector gGraphs;
    private DefaultViewAdapter vl;
    private Color nodeColor = Color.yellow;
    private Color arcColor = Color.blue;
    private String name;
    private HashMap shiftMap = new HashMap();
    private int initialShift = 2;
    private int stepShift = 6;
    private HashMap nodeLabel;
    private HashMap arcLabel;
    private HashMap labels;
    private boolean DEFAULT_VISIBLE_LABEL = true;
    private String[] DEFAULT_NODE_LABEL = new String[]{"$(name)"};
    private String[] DEFAULT_ARC_LABEL = new String[]{""};
    protected boolean updateLabelsWhenValuesChange = false;

    protected GLayer(String name, DefaultViewAdapter vl) {
        this.vl = vl;
        this.name = name;
        this.gGraphs = new Vector();
        this.nodeLabel = new HashMap();
        this.arcLabel = new HashMap();
        this.labels = new HashMap();
    }

    protected DefaultViewAdapter getDefaultViewAdapter() {
        return this.vl;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            this.name = "No name";
        }
        return this.name;
    }

    public void updateLabelsWhenValuesChange(boolean update) {
        this.updateLabelsWhenValuesChange = update;
    }

    protected void addGraph(AbstractGraph graph) {
        LabelNameVisible lnvArc;
        if (this.gGraphs.contains(graph)) {
            System.out.println("le graph " + graph + " est deja ds layer " + this.toString());
            return;
        }
        this.gGraphs.add(new GGraph(graph, this));
        LabelNameVisible lnvNode = (LabelNameVisible)this.nodeLabel.get(graph);
        if (lnvNode == null) {
            lnvNode = new LabelNameVisible(this.DEFAULT_NODE_LABEL, this.DEFAULT_VISIBLE_LABEL);
            this.nodeLabel.put(graph, lnvNode);
        }
        if ((lnvArc = (LabelNameVisible)this.arcLabel.get(graph)) == null) {
            lnvArc = new LabelNameVisible(this.DEFAULT_ARC_LABEL, this.DEFAULT_VISIBLE_LABEL);
            this.arcLabel.put(graph, lnvArc);
        }
        if (lnvNode.visible) {
            this.addLabels(graph.getAbstractVertexSet(), graph, lnvNode.name);
        }
        if (lnvArc.visible) {
            this.addLabels(graph.getAbstractEdgeSet(), graph, lnvArc.name);
        }
    }

    protected boolean removeGraph(AbstractGraph graph) {
        GGraph ggraph = this.getGGraph(graph);
        if (ggraph == null) {
            return false;
        }
        this.removeGGraph(graph);
        ggraph.remove();
        this.removeLabels(graph.getAbstractVertexSet(), graph);
        this.removeLabels(graph.getAbstractEdgeSet(), graph);
        return true;
    }

    protected void setVisibleGraph(AbstractGraph graph, boolean visible) {
        GGraph ggraph = this.getGGraph(graph);
        if (ggraph == null) {
            return;
        }
        ggraph.setVisible(visible);
    }

    protected Vector getGGraphs() {
        return this.gGraphs;
    }

    protected GGraph getGGraph(AbstractGraph ag) {
        int nbGGraph = this.gGraphs.size();
        for (int i = 0; i < nbGGraph; ++i) {
            GGraph gg = (GGraph)this.gGraphs.elementAt(i);
            if (gg.getGraph() != ag) continue;
            return gg;
        }
        return null;
    }

    protected void removeGGraph(AbstractGraph ag) {
        int nbGGraph = this.gGraphs.size();
        for (int i = 0; i < nbGGraph; ++i) {
            GGraph gg = (GGraph)this.gGraphs.elementAt(i);
            if (gg.getGraph() != ag) continue;
            this.gGraphs.removeElementAt(i);
            return;
        }
    }

    protected void removeAllGraph() {
        int nbGGraph = this.gGraphs.size();
        for (int i = 0; i < nbGGraph; ++i) {
            ((GGraph)this.gGraphs.elementAt(i)).remove();
        }
        this.gGraphs = new Vector(100);
        this.shiftMap = new HashMap();
    }

    protected boolean contains(AbstractGraph ag) {
        return this.getGGraph(ag) != null;
    }

    public void setNodeLabel(AbstractGraph graph, String value) {
        this.setNodeLabel(graph, value.split("\n"));
    }

    public void setArcLabel(AbstractGraph graph, String value) {
        this.setArcLabel(graph, value.split("\n"));
    }

    public void setNodeLabel(AbstractGraph graph, String[] value) {
        LabelNameVisible lnv = (LabelNameVisible)this.nodeLabel.get(graph);
        if (lnv == null) {
            lnv = new LabelNameVisible(value, this.DEFAULT_VISIBLE_LABEL);
            this.nodeLabel.put(graph, lnv);
        } else {
            lnv.name = value;
        }
        if (lnv.visible && this.getGGraph(graph) != null) {
            this.setVisibleLabels(true);
        }
    }

    public void setArcLabel(AbstractGraph graph, String[] value) {
        LabelNameVisible lnv = (LabelNameVisible)this.arcLabel.get(graph);
        if (lnv == null) {
            lnv = new LabelNameVisible(value, this.DEFAULT_VISIBLE_LABEL);
            this.arcLabel.put(graph, lnv);
        } else {
            lnv.name = value;
        }
        if (lnv.visible && this.getGGraph(graph) != null) {
            this.setVisibleLabels(true);
        }
    }

    public String[] getNodeLabel(AbstractGraph graph) {
        LabelNameVisible lnv = (LabelNameVisible)this.nodeLabel.get(graph);
        if (lnv == null) {
            System.out.println("no nodeLabel set for graph" + graph.getName());
            return null;
        }
        return lnv.name;
    }

    public String[] getArcLabel(AbstractGraph graph) {
        LabelNameVisible lnv = (LabelNameVisible)this.arcLabel.get(graph);
        if (lnv == null) {
            System.out.println("no arcLabel set for graph" + graph.getName());
            return null;
        }
        return lnv.name;
    }

    public void setVisibleLabels(AbstractGraph graph, boolean visible) {
        LabelNameVisible lnv = (LabelNameVisible)this.nodeLabel.get(graph);
        if (lnv != null) {
            lnv.visible = visible;
            this.removeLabels(graph.getAbstractVertexSet(), graph);
            if (visible) {
                this.addLabels(graph.getAbstractVertexSet(), graph, lnv.name);
            }
        }
        if ((lnv = (LabelNameVisible)this.arcLabel.get(graph)) != null) {
            lnv.visible = visible;
            this.removeLabels(graph.getAbstractEdgeSet(), graph);
            if (visible) {
                this.addLabels(graph.getAbstractEdgeSet(), graph, lnv.name);
            }
        }
        this.repaint();
    }

    public void hideLabels(boolean hide) {
        Iterator it = this.labels.values().iterator();
        while (it.hasNext()) {
            Label lab = (Label)it.next();
            if (hide) {
                this.remove(lab);
                continue;
            }
            this.add(lab);
        }
        this.repaint();
    }

    protected void removeLabel(MascoptObject obj, AbstractGraph context) {
        Label l = (Label)this.labels.get(this.hash(obj, context));
        if (l == null) {
            return;
        }
        this.remove(l);
        this.labels.remove(this.hash(obj, context));
    }

    protected void addLabel(MascoptObject obj, AbstractGraph context, String[] lines) {
        String[] lab;
        GGraph ggraph = this.getGGraph(context);
        if (ggraph == null) {
            System.out.println("le graph " + context + " n'est pas dans le layer " + this.toString());
            return;
        }
        GObject gobject = ggraph.getGObject(obj);
        if (lines != null && ((lab = this.resolveValues(lines, obj, context)).length != 1 || !lab[0].equals("??") && !lab[0].equals(""))) {
            double ratioY;
            double ratioX;
            if (obj instanceof AbstractVertex) {
                ratioX = 0.0;
                ratioY = -0.5;
            } else {
                ratioX = 0.5;
                ratioY = 0.5;
            }
            Label label = new Label(gobject, lab, ratioX, ratioY);
            this.labels.put(this.hash(obj, context), label);
            this.add(label);
        }
    }

    protected void updateLabel(MascoptObject obj, AbstractGraph context, String[] lines) {
        LabelNameVisible lnv_node = (LabelNameVisible)this.nodeLabel.get(context);
        if (obj instanceof AbstractVertex && lnv_node != null && lnv_node.visible) {
            this.removeLabel(obj, context);
            this.addLabel(obj, context, lines);
        }
        LabelNameVisible lnv_arc = (LabelNameVisible)this.arcLabel.get(context);
        if (obj instanceof AbstractVertex && lnv_arc != null && lnv_arc.visible) {
            this.removeLabel(obj, context);
            this.addLabel(obj, context, lines);
        }
    }

    private void removeLabels(MascoptSet set, AbstractGraph context) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            this.removeLabel((MascoptObject)it.next(), context);
        }
    }

    private void addLabels(MascoptSet set, AbstractGraph context, String[] lines) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            this.addLabel((MascoptObject)it.next(), context, lines);
        }
    }

    public void setVisibleLabels(boolean visible) {
        int nbGGraph = this.gGraphs.size();
        for (int i = 0; i < nbGGraph; ++i) {
            this.setVisibleLabels(((GGraph)this.gGraphs.elementAt(i)).getGraph(), visible);
        }
    }

    private String[] resolveValues(String[] code, MascoptObject mo, AbstractGraph context) {
        String[] ret = new String[code.length];
        for (int i = 0; i < code.length; ++i) {
            String resolved = "";
            String str = code[i];
            StringTokenizer st = new StringTokenizer(code[i], "$", false);
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (tok.equals(str)) {
                    resolved = resolved + tok;
                    continue;
                }
                if (tok.startsWith("(")) {
                    int endIndex = tok.indexOf(41);
                    if (endIndex == -1) {
                        resolved = resolved + tok;
                        continue;
                    }
                    String toResolve = tok.substring(1, endIndex);
                    String dataType = mo.getValueDataType(toResolve, context);
                    String value = mo.getValue(toResolve, context);
                    if (value == null) {
                        value = "??";
                    }
                    resolved = resolved + value;
                    resolved = resolved + tok.substring(endIndex + 1);
                    continue;
                }
                resolved = resolved + tok;
            }
            ret[i] = resolved;
        }
        return ret;
    }

    private String hash(MascoptObject mo, AbstractGraph context) {
        return mo.getId() + context.getId();
    }

    public int getInitialShift() {
        return this.initialShift;
    }

    public void setInitialShift(int i) {
        this.initialShift = i;
    }

    public int getStepShift() {
        return this.stepShift;
    }

    public void setStepShift(int i) {
        this.stepShift = i;
    }

    private String getKey(GVertex n0, GVertex n1) {
        return n0.getAbstractVertex().getId() + n1.getAbstractVertex().getId();
    }

    private int getMinAndRemove(Vector v) {
        if (v.size() == 0) {
            return -1;
        }
        int min = (Integer)v.elementAt(0);
        int indexMin = 0;
        for (int i = 1; i < v.size(); ++i) {
            int t = (Integer)v.elementAt(i);
            if (t >= min) continue;
            min = t;
            indexMin = i;
        }
        v.remove(indexMin);
        return min;
    }

    public int addShift(GVertex n0, GVertex n1) {
        String key = this.getKey(n0, n1);
        Vector<Integer> free = (Vector<Integer>)this.shiftMap.get(key);
        if (free == null) {
            free = new Vector<Integer>();
            free.add(new Integer(this.initialShift + this.stepShift));
            this.shiftMap.put(key, free);
            return this.initialShift;
        }
        int retVal = this.getMinAndRemove(free);
        if (free.size() == 0) {
            free.add(new Integer(retVal + this.stepShift));
        }
        return retVal;
    }

    public void removeShift(GVertex n0, GVertex n1, int h) {
        String key = this.getKey(n0, n1);
        Vector free = (Vector)this.shiftMap.get(key);
        if (free == null) {
            System.out.println("ERREUR ???");
            return;
        }
        free.insertElementAt(new Integer(h), 0);
    }

    protected void finalize() throws Throwable {
        Trace.println("ON FINALISE UN LAYER !!!", Trace.MEMORY);
        super.finalize();
    }
}

