/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.gui.Selectable;
import mascoptLib.gui.views.GObject;

public class GVertex
extends GObject
implements Selectable {
    private AbstractVertex node;
    private Color color;
    private Color colorOn = Color.red;
    private Color colorOff;
    private Color colorSelect;

    public GVertex(AbstractVertex n, int w, int h, Color col) {
        super((int)Math.round(n.getX()), (int)Math.round(n.getY()), w, h);
        this.colorOff = col;
        this.colorSelect = Color.green;
        this.color = col;
        this.node = n;
    }

    public void delete() {
    }

    public AbstractVertex getAbstractVertex() {
        return this.node;
    }

    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        if (this.node != null) {
            int xNode = (int)Math.round(this.node.getX());
            int yNode = (int)Math.round(this.node.getY());
            if (xNode != x) {
                this.node.setX(x);
            }
            if (yNode != y) {
                this.node.setY(y);
            }
        }
    }

    public void setColor(Color newColor) {
        this.colorOff = newColor;
        this.color = newColor;
    }

    public Color getColor() {
        return this.color;
    }

    public void select() {
        this.color = this.colorSelect;
        this.repaint();
    }

    public void enter() {
        this.color = this.colorOn;
        this.repaint();
    }

    public void exit() {
        this.color = this.colorOff;
        this.repaint();
    }

    public void paint(Graphics g) {
        ((Graphics2D)g).setPaint(new GradientPaint(0.0f, 0.0f, this.color, this.getWidth(), this.getHeight(), this.color.darker().darker()));
        g.fillOval(0, 0, this.getWidth(), this.getHeight());
    }
}

