/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.gui.Filter;
import mascoptLib.io.ReaderInterface;
import mascoptLib.io.graph.MGLReader;

public class GraphChooser {
    public static Vector getGraph(ReaderInterface ri, int number) {
        Vector<AbstractGraph> ret = new Vector<AbstractGraph>();
        Iterator itg = ri.getAbstractGraphs();
        for (int i = 0; i < number; ++i) {
            AbstractGraph the_graph = (AbstractGraph)itg.next();
            ret.add(the_graph);
        }
        return ret;
    }

    public static AbstractGraph getGraph(ReaderInterface ri) {
        GraphChooser.checkTheme();
        Hashtable<String, AbstractGraph> ht = new Hashtable<String, AbstractGraph>();
        Iterator graphs = ri.getAbstractGraphs();
        while (graphs.hasNext()) {
            AbstractGraph ag = (AbstractGraph)graphs.next();
            String name = ag.getName();
            if (name == null) {
                name = "no name (" + ag.getAbstractVertexSet().size() + " nodes, " + ag.getAbstractEdgeSet() + " edges";
            }
            ht.put(name, ag);
        }
        Object[] names = new String[ht.size()];
        ht.keySet().toArray(names);
        String graphNameSelected = ht.size() == 1 ? names[0] : (String)JOptionPane.showInputDialog(null, "Choose one graph", "Graph Chooser", 2, null, names, names[0]);
        if (graphNameSelected == null) {
            return null;
        }
        return (AbstractGraph)ht.get(graphNameSelected);
    }

    public static AbstractGraph getGraphMGL() {
        MGLReader mglr = GraphChooser.getMGLReader();
        AbstractGraph resultGraph = null;
        if (mglr == null) {
            return null;
        }
        try {
            mglr.parse();
            resultGraph = GraphChooser.getGraph(mglr);
        }
        catch (Exception e) {
            System.out.println("Catched exception " + e);
            resultGraph = GraphChooser.abstractGraphOnError();
        }
        return resultGraph;
    }

    public static Vector getGraphMGL(int number) {
        MGLReader mglr = GraphChooser.getMGLReader();
        if (mglr == null) {
            return null;
        }
        return GraphChooser.getGraph(mglr, number);
    }

    public static Vector getGraphVectorMGL() {
        MGLReader mglr = GraphChooser.getMGLReader();
        Vector resultVector = null;
        if (mglr == null) {
            return null;
        }
        try {
            mglr.parse();
            resultVector = GraphChooser.getGraph(mglr, mglr.getNumberOfGraphs());
        }
        catch (Exception e) {
            resultVector = GraphChooser.getGraphVectorMGL();
        }
        return resultVector;
    }

    public static AbstractGraph getGraphMGL(String file) {
        MGLReader mglr = null;
        try {
            mglr = new MGLReader(file);
        }
        catch (FileNotFoundException e) {
            System.out.println("Sorry, the file " + file + " was not found.");
        }
        AbstractGraph resultGraph = null;
        try {
            mglr.parse();
            resultGraph = GraphChooser.getGraph(mglr);
        }
        catch (Exception e) {
            resultGraph = GraphChooser.abstractGraphOnError();
        }
        return resultGraph;
    }

    public static Vector getGraphMGL(String file, int number) {
        MGLReader mglr = null;
        try {
            mglr = new MGLReader(file);
        }
        catch (FileNotFoundException e) {
            System.out.println("Sorry, the file " + file + " was not found.");
        }
        Vector resultVector = null;
        try {
            mglr.parse();
            resultVector = GraphChooser.getGraph(mglr, number);
        }
        catch (Exception e) {
            System.out.println("Catched exception " + e);
            JOptionPane.showMessageDialog(null, "An error occured while parsing. Please choose another file.", "Error", 0);
            resultVector = GraphChooser.getGraphMGL(number);
        }
        return resultVector;
    }

    public static Vector getGraphVectorMGL(String filename) {
        MGLReader mglr = null;
        try {
            mglr = new MGLReader(filename);
        }
        catch (FileNotFoundException e) {
            System.out.println("Sorry, the file " + filename + " was not found.");
        }
        Vector resultVector = null;
        try {
            mglr.parse();
            resultVector = GraphChooser.getGraph(mglr, mglr.getNumberOfGraphs());
        }
        catch (Exception e) {
            System.out.println("Catched exception " + e);
            JOptionPane.showMessageDialog(null, "An error occured while parsing. Please choose another file.", "Error", 0);
            resultVector = GraphChooser.getGraphVectorMGL();
        }
        return resultVector;
    }

    public static MGLReader getMGLReader() {
        String fileName = GraphChooser.getFileName("", new String[]{"xml", "mgl"}, "mascopt files", "Load");
        if (fileName == null) {
            return null;
        }
        MGLReader mglr = null;
        try {
            mglr = new MGLReader(fileName);
        }
        catch (FileNotFoundException e) {
            System.out.println("Sorry, the file " + fileName + " was not found.");
        }
        return mglr;
    }

    public static String getFileName(String root, String[] filter, String ident, String actionText) {
        File theFile;
        GraphChooser.checkTheme();
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText(actionText);
        Filter myFilter = new Filter(filter, ident);
        chooser.addChoosableFileFilter(myFilter);
        chooser.setFileFilter(myFilter);
        File rootFile = new File(root);
        chooser.setCurrentDirectory(rootFile);
        int retval = chooser.showOpenDialog(null);
        if (retval == 0 && (theFile = chooser.getSelectedFile()) != null) {
            return theFile.getAbsolutePath();
        }
        return null;
    }

    private static void checkTheme() {
    }

    private static AbstractGraph abstractGraphOnError() {
        JOptionPane.showMessageDialog(null, "An error occured while parsing. Please choose another file.", "Error", 0);
        return GraphChooser.getGraphMGL();
    }

    public static HashMap getGraphHashMapMGL() {
        Vector v = GraphChooser.getGraphVectorMGL();
        HashMap<String, AbstractGraph> result = new HashMap<String, AbstractGraph>();
        Iterator v_it = v.iterator();
        while (v_it.hasNext()) {
            AbstractGraph g = (AbstractGraph)v_it.next();
            result.put(new String(g.getName()), g);
        }
        return result;
    }

    public static HashMap getGraphHashMapMGL(String filename) {
        Vector v = GraphChooser.getGraphVectorMGL(filename);
        HashMap<String, AbstractGraph> result = new HashMap<String, AbstractGraph>();
        Iterator v_it = v.iterator();
        while (v_it.hasNext()) {
            AbstractGraph g = (AbstractGraph)v_it.next();
            result.put(new String(g.getName()), g);
        }
        return result;
    }
}

