/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.gui.GLayer;
import mascoptLib.gui.GVertex;
import mascoptLib.gui.GView;
import mascoptLib.gui.ViewListener;
import mascoptLib.gui.views.LayerInfo;
import mascoptLib.util.Trace;

class LayerManager {
    private ViewListener vl;
    private Vector glayers;
    private Vector gviews = new Vector();
    private Vector agraphs;

    public LayerManager() {
        this.glayers = new Vector();
        this.agraphs = new Vector();
        this.vl = new ViewListener(this);
    }

    public GView newView() {
        int nbViews = this.gviews.size();
        return this.newView("View #" + (nbViews + 1));
    }

    public GView newView(String name) {
        return this.newView(name, 0, 0);
    }

    public GView newView(String name, int centerX, int centerY) {
        return this.newView(name, centerY, centerY, 1.0);
    }

    public GView newView(String name, int centerX, int centerY, double zoom) {
        if (this.getView(name) != null) {
            return this.newView(name + "'");
        }
        GView v = new GView(name, centerX, centerY, zoom);
        v.addMouseMotionListener(this.vl);
        v.addMouseListener(this.vl);
        v.addMouseWheelListener(this.vl);
        this.gviews.add(v);
        return v;
    }

    public GLayer newLayer(String name) {
        if (this.getLayer(name) != null) {
            return this.newLayer(name + "'");
        }
        GLayer gl = new GLayer(name, this.vl);
        this.glayers.add(gl);
        return gl;
    }

    public void newGraph(AbstractGraph g) {
        if (this.agraphs.contains(g)) {
            return;
        }
        if (g.getName() == null) {
            g.setName("No Name #" + this.agraphs.size());
        }
        this.agraphs.add(g);
    }

    public boolean removeGraph(AbstractGraph g) {
        System.out.println("remove graph dans Layer manager" + g.getName());
        return this.agraphs.remove(g);
    }

    public boolean addLayerInView(GLayer l, GView v) {
        if (v.contains(l)) {
            return false;
        }
        v.addLayer(l);
        v.repaint();
        return true;
    }

    public HashSet destroyLayer(GLayer layer) {
        Vector views = this.getViews();
        Iterator itv = views.iterator();
        HashSet<GView> viewsConcerned = new HashSet<GView>();
        while (itv.hasNext()) {
            GView v = (GView)itv.next();
            viewsConcerned.add(v);
        }
        this.glayers.remove(layer);
        layer.removeAllGraph();
        return viewsConcerned;
    }

    public boolean removeLayerInView(GLayer l, GView v) {
        if (v.getLayerIndex(l) == -1) {
            return false;
        }
        v.removeLayer(l);
        v.repaint();
        return true;
    }

    public void setVisibleLayerInView(GLayer l, GView v, boolean visible) {
        v.setVisibleLayer(l, visible);
        v.repaint();
    }

    public void moveUpLayerInView(GLayer l, GView v) {
        int position = v.getLayerIndex(l);
        if (position == -1) {
            System.out.println(v + " ne contient pas " + l);
            return;
        }
        if (position == 0) {
            return;
        }
        LayerInfo li = v.getLayerInfo(l);
        v.removeLayer(l);
        v.insertLayerInfo(position - 1, li);
        v.repaint();
    }

    public void moveDownLayerInView(GLayer l, GView v) {
        int position = v.getLayerIndex(l);
        if (position == -1) {
            System.out.println(v + " ne contient pas " + l);
            return;
        }
        if (position == v.getLayerCount() - 1) {
            return;
        }
        LayerInfo li = v.getLayerInfo(l);
        v.removeLayer(l);
        v.insertLayerInfo(position + 1, li);
        v.repaint();
    }

    public void moveUpGraphInLayer(AbstractGraph ag, GLayer gl) {
    }

    public void moveDownGraphInLayer(AbstractGraph ag, GLayer gl) {
    }

    public void setVisibleGraphInLayer(AbstractGraph g, GLayer gl, boolean visible) {
        if (visible && !gl.contains(g)) {
            gl.addGraph(g);
        } else {
            gl.removeGraph(g);
        }
    }

    public void hideLabelsFor(GVertex gnode) {
    }

    public void setVisibleLabels(GLayer gl, boolean visible) {
        gl.setVisibleLabels(visible);
    }

    public void setVisibleLabels(boolean visible) {
        int nbGlayers = this.glayers.size();
        for (int i = 0; i < nbGlayers; ++i) {
            ((GLayer)this.glayers.elementAt(i)).setVisibleLabels(visible);
        }
    }

    public void hideLabels(GLayer gl, boolean hide) {
        gl.hideLabels(hide);
    }

    public void hideLabels(boolean hide) {
        int nbGlayers = this.glayers.size();
        for (int i = 0; i < nbGlayers; ++i) {
            ((GLayer)this.glayers.elementAt(i)).hideLabels(hide);
        }
    }

    public void setNodeLabelGraphInLayer(AbstractGraph graph, GLayer l, String[] value) {
        l.setNodeLabel(graph, value);
    }

    public void setArcLabelGraphInLayer(AbstractGraph graph, GLayer l, String[] value) {
        l.setArcLabel(graph, value);
    }

    public String[] getNodeLabelGraphInLayer(AbstractGraph graph, GLayer l) {
        return l.getNodeLabel(graph);
    }

    public String[] getArcLabelGraphInLayer(AbstractGraph graph, GLayer l) {
        return l.getArcLabel(graph);
    }

    public Vector getViews() {
        return this.gviews;
    }

    public GView getView(String name) {
        int nbView = this.gviews.size();
        for (int i = 0; i < nbView; ++i) {
            GView gv = (GView)this.gviews.elementAt(i);
            if (!gv.getName().equalsIgnoreCase(name)) continue;
            return gv;
        }
        return null;
    }

    public Vector getLayers() {
        return this.glayers;
    }

    public GLayer getLayer(String name) {
        int nbLayer = this.glayers.size();
        for (int i = 0; i < nbLayer; ++i) {
            GLayer gl = (GLayer)this.glayers.elementAt(i);
            if (!gl.getName().equalsIgnoreCase(name)) continue;
            return gl;
        }
        return null;
    }

    public AbstractGraph getGraph(String name) {
        int nbGraph = this.agraphs.size();
        for (int i = 0; i < nbGraph; ++i) {
            AbstractGraph ag = (AbstractGraph)this.agraphs.elementAt(i);
            if (!ag.getName().equalsIgnoreCase(name)) continue;
            return ag;
        }
        return null;
    }

    public Vector purgeUnusedGraphs(Vector graphsHavingAnEntry) {
        Vector<String> unusedGraphs = new Vector<String>();
        Vector agraphs_prime = (Vector)this.agraphs.clone();
        agraphs_prime.removeAll(graphsHavingAnEntry);
        this.agraphs.removeAll(agraphs_prime);
        Iterator itGraphToRemove = agraphs_prime.iterator();
        while (itGraphToRemove.hasNext()) {
            AbstractGraph ag = (AbstractGraph)itGraphToRemove.next();
            unusedGraphs.add(ag.getName());
            Trace.println("Purge process: Graph " + ag.getName() + " dropped.");
        }
        return unusedGraphs;
    }
}

