/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.gui.Editor;
import mascoptLib.gui.GLayer;
import mascoptLib.gui.GView;
import mascoptLib.gui.GraphChooser;
import mascoptLib.gui.LayerManager;
import mascoptLib.gui.PanelLine;
import mascoptLib.gui.ScrollPanelLine;
import mascoptLib.gui.ThemeManager;
import mascoptLib.io.graph.MGLReader;

public class MascoptViewer
extends JFrame
implements ActionListener,
ItemListener {
    private LayerManager lm;
    private JTabbedPane jtpMain;
    private JTabbedPane jtpView;
    private JTabbedPane jtpLayer;
    private JPanel jpEditor;
    private JComboBox jcbAddGraph;
    private JComboBox jcbAddLayer;

    public MascoptViewer() {
        this("modernthemepack.zip");
    }

    public MascoptViewer(String themeFile) {
        super("Mascopt Viewer");
        ThemeManager tm = new ThemeManager();
        tm.setTheme(themeFile);
        this.lm = new LayerManager();
        this.setDefaultCloseOperation(3);
        JToolBar jtbViewButton = new JToolBar();
        JButton jbUp = new JButton("^");
        jbUp.addActionListener(this);
        JButton jbDown = new JButton("v");
        jbDown.addActionListener(this);
        JButton jbClose = new JButton("X");
        jbClose.addActionListener(this);
        JButton jbNewView = new JButton("New View");
        jbNewView.addActionListener(this);
        JButton jbNewEditor = new JButton("New Editor");
        jbNewEditor.addActionListener(this);
        String[] st = new String[]{"Add Layer", "New Layer"};
        this.jcbAddLayer = new JComboBox<String>(st);
        this.jcbAddLayer.addItemListener(this);
        String[] st2 = new String[]{"Add Graph", "Scan File"};
        this.jcbAddGraph = new JComboBox<String>(st2);
        this.jcbAddGraph.addItemListener(this);
        jtbViewButton.add(jbUp);
        jtbViewButton.add(jbDown);
        jtbViewButton.add(jbClose);
        jtbViewButton.addSeparator();
        jtbViewButton.add(jbNewView);
        jtbViewButton.addSeparator();
        jtbViewButton.add(jbNewEditor);
        jtbViewButton.addSeparator();
        jtbViewButton.add(this.jcbAddLayer);
        jtbViewButton.addSeparator();
        jtbViewButton.add(this.jcbAddGraph);
        this.jtpView = new JTabbedPane();
        this.jtpView.setTabPlacement(2);
        JPanel jpView = new JPanel();
        jpView.setLayout(new BorderLayout());
        jpView.add("Center", this.jtpView);
        this.jtpLayer = new JTabbedPane();
        this.jtpLayer.setTabPlacement(2);
        JPanel jpLayer = new JPanel();
        jpLayer.setLayout(new BorderLayout());
        jpLayer.add("Center", this.jtpLayer);
        this.jpEditor = new JPanel();
        this.jtpMain = new JTabbedPane();
        this.jtpMain.setTabPlacement(1);
        this.jtpMain.add("VIEWS", jpView);
        this.jtpMain.add("LAYERS", jpLayer);
        this.jtpMain.add("EDITOR", this.jpEditor);
        this.getContentPane().add("North", jtbViewButton);
        this.getContentPane().add("Center", this.jtpMain);
        this.setSize(400, 200);
        this.setVisible(true);
    }

    private void newEditor() {
        this.jpEditor.removeAll();
        this.jpEditor.add(new Editor());
    }

    public GView newView() {
        return this.createViewFrame(this.lm.newView());
    }

    public GView newView(String name) {
        return this.createViewFrame(this.lm.newView(name));
    }

    public GView newView(String name, int centerX, int centerY) {
        return this.createViewFrame(this.lm.newView(name, centerX, centerY));
    }

    public GView newView(String name, int centerX, int centerY, double zoom, int width, int height, int locationX, int locationY) {
        return this.createViewFrame(this.lm.newView(name, centerX, centerY, zoom), width, height, locationX, locationY);
    }

    public GView newView(String name, int centerX, int centerY, double zoom, int width, int height, int locationX, int locationY, String title) {
        return this.createViewFrame(this.lm.newView(name, centerX, centerY, zoom), width, height, locationX, locationY, title);
    }

    public GView newView(String name, int centerX, int centerY, double zoom, int width, int height, int locationX, int locationY, JPanel title) {
        return this.createViewFrame(this.lm.newView(name, centerX, centerY, zoom), width, height, locationX, locationY, title);
    }

    public void closeView(String name) {
        this.jtpView.removeTabAt(this.jtpView.indexOfTab(name));
    }

    public GLayer newLayer(String name) {
        GLayer create = this.lm.newLayer(name);
        name = create.getName();
        this.jcbAddLayer.addItem(name);
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        this.jtpLayer.add(name, jp);
        JPanel controlLayer = new JPanel();
        controlLayer.add(new JLabel(name + " infos"));
        ScrollPanelLine sl = this.newScrollGraphLine();
        jp.add((Component)controlLayer, "North");
        jp.add((Component)sl, "Center");
        return create;
    }

    public void destroyLayer(GLayer layer) {
        HashSet viewsConcerned = this.lm.destroyLayer(layer);
        Iterator itv = viewsConcerned.iterator();
        while (itv.hasNext()) {
            GView v = (GView)itv.next();
            this.removeLayerInView(layer, v);
        }
        this.jtpLayer.removeTabAt(this.jtpLayer.indexOfTab(layer.getName()));
    }

    public void newGraph(AbstractGraph g) {
        this.lm.newGraph(g);
        this.addInJCB(this.jcbAddGraph, g.getName());
    }

    public void addLayerInView(GLayer l, GView v) {
        if (!this.lm.addLayerInView(l, v)) {
            JOptionPane.showMessageDialog(this, "layer " + l.getName() + " already in View " + v.getName(), "error", 0);
            return;
        }
        ScrollPanelLine spl = this.getSPL(this.jtpView, v.getName());
        PanelLine ll = new PanelLine(l, l.getName());
        ll.addActionListener(this);
        spl.addPanelLine(ll);
        this.setVisibleLayerInView(l, v, true);
        this.repaint();
    }

    public void addGraphInLayer(AbstractGraph g, GLayer l) {
        this.addGraphInLayer(g, l, false);
    }

    public void addGraphInLayer(AbstractGraph g, GLayer l, boolean visible) {
        if (g == null) {
            new RuntimeException("Graph g is null. Cannot add it in the layer !");
        }
        this.newGraph(g);
        ScrollPanelLine spl = this.getSPL(this.jtpLayer, l.getName());
        if (spl.getPanelLine(g) != null) {
            JOptionPane.showMessageDialog(this, "graph " + g.getName() + " already in Layer " + l.getName(), "error", 0);
            return;
        }
        PanelLine ll = new PanelLine(g, g.getName());
        ll.addActionListener(this);
        spl.addPanelLine(ll);
        this.setVisibleGraphInLayer(g, l, visible);
        this.repaint();
    }

    public void setVisibleGraphInLayer(AbstractGraph g, GLayer l, boolean visible) {
        this.lm.setVisibleGraphInLayer(g, l, visible);
        ScrollPanelLine spl = this.getSPL(this.jtpLayer, l.getName());
        spl.setVisible(g, visible);
        l.repaint();
    }

    public void setVisibleLayerInView(GLayer l, GView v, boolean visible) {
        this.lm.setVisibleLayerInView(l, v, visible);
        ScrollPanelLine spl = this.getSPL(this.jtpView, v.getName());
        spl.setVisible(l, visible);
    }

    public void setVisibleLabels(GLayer gl, boolean visible) {
        this.lm.setVisibleLabels(gl, visible);
    }

    public void moveUpLayerInView(GLayer gl, GView gv) {
        this.lm.moveUpLayerInView(gl, gv);
        ScrollPanelLine spl = this.getSPL(this.jtpView, gv.getName());
        spl.moveUp(gl);
        this.repaint();
    }

    public void moveDownLayerInView(GLayer gl, GView gv) {
        this.lm.moveDownLayerInView(gl, gv);
        ScrollPanelLine spl = this.getSPL(this.jtpView, gv.getName());
        spl.moveDown(gl);
        this.repaint();
    }

    public void removeLayerInView(GLayer gl, GView gv) {
        if (!this.lm.removeLayerInView(gl, gv)) {
            return;
        }
        ScrollPanelLine spl = this.getSPL(this.jtpView, gv.getName());
        spl.remove(gl);
        this.repaint();
    }

    public void moveUpGraphInLayer(AbstractGraph ag, GLayer gl) {
        System.out.println("ca bouge pas");
    }

    public void moveDownGraphInLayer(AbstractGraph ag, GLayer gl) {
        System.out.println("ca bouge pas");
    }

    public void removeGraphInLayer(AbstractGraph ag, GLayer gl) {
        this.setVisibleGraphInLayer(ag, gl, false);
        ScrollPanelLine spl = this.getSPL(this.jtpLayer, gl.getName());
        spl.remove(ag);
        this.repaint();
    }

    public void setNodeLabelGraphInLayer(AbstractGraph graph, GLayer l, String[] value) {
        this.lm.setNodeLabelGraphInLayer(graph, l, value);
    }

    public void setArcLabelGraphInLayer(AbstractGraph graph, GLayer l, String[] value) {
        this.lm.setArcLabelGraphInLayer(graph, l, value);
    }

    public void setNodeLabelGraphInLayer(AbstractGraph graph, GLayer l, String value) {
        this.lm.setNodeLabelGraphInLayer(graph, l, value.split("\n"));
    }

    public void setArcLabelGraphInLayer(AbstractGraph graph, GLayer l, String value) {
        this.lm.setArcLabelGraphInLayer(graph, l, value.split("\n"));
    }

    public String[] getNodeLabelGraphInLayer(AbstractGraph graph, GLayer l) {
        return this.lm.getNodeLabelGraphInLayer(graph, l);
    }

    public String[] getArcLabelGraphInLayer(AbstractGraph graph, GLayer l) {
        return this.lm.getArcLabelGraphInLayer(graph, l);
    }

    public boolean removeGraph(AbstractGraph graph) {
        boolean ok = false;
        ok = this.lm.removeGraph(graph);
        if (ok) {
            this.removeInJCB(this.jcbAddGraph, graph.getName());
        }
        return ok;
    }

    private GView createViewFrame(GView v) {
        return this.createViewFrame(v, 400, 400, 500, 500);
    }

    private GView createViewFrame(GView v, int w, int h, int xLocation, int yLocation) {
        return this.createViewFrame(v, w, h, xLocation, yLocation, new JPanel());
    }

    private GView createViewFrame(GView v, int w, int h, int xLocation, int yLocation, String title) {
        return this.createViewFrame(v, w, h, xLocation, yLocation, title.split("\n"));
    }

    private GView createViewFrame(GView v, int w, int h, int xLocation, int yLocation, String[] title) {
        JPanel lab = new JPanel();
        lab.setLayout(new BoxLayout(lab, 1));
        for (int i = 0; i < title.length; ++i) {
            lab.add(new JLabel(title[i]));
        }
        return this.createViewFrame(v, w, h, xLocation, yLocation, lab);
    }

    private GView createViewFrame(GView v, int w, int h, int xLocation, int yLocation, JPanel title) {
        JFrame jfView = new JFrame(v.getName());
        jfView.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MascoptViewer.this.closeView(((JFrame)e.getSource()).getTitle());
            }
        });
        JPanel jpM = new JPanel();
        jpM.setLayout(new BorderLayout());
        if (title != null) {
            jpM.add((Component)title, "North");
        }
        jpM.add((Component)v, "Center");
        jfView.getContentPane().add(jpM);
        v.setPreferredSize(new Dimension(w, h));
        jfView.pack();
        jfView.setLocation(xLocation, yLocation);
        jfView.setVisible(true);
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        this.jtpView.add(v.getName(), jp);
        JPanel controlView = new JPanel();
        controlView.add(new JLabel("View " + v.getName()));
        ScrollPanelLine sl = this.newScrollLayerLine();
        jp.add((Component)controlView, "North");
        jp.add((Component)sl, "Center");
        return v;
    }

    private GLayer getLayerSelected() {
        JPanel jp = (JPanel)this.jtpView.getSelectedComponent();
        if (jp == null) {
            return null;
        }
        ScrollPanelLine spl = (ScrollPanelLine)jp.getComponent(1);
        PanelLine pl = spl.getSelected();
        if (pl == null) {
            System.out.println("no layer selected");
            return null;
        }
        return (GLayer)pl.getModel();
    }

    private AbstractGraph getGraphSelected() {
        JPanel jp = (JPanel)this.jtpLayer.getSelectedComponent();
        if (jp == null) {
            return null;
        }
        ScrollPanelLine spl = (ScrollPanelLine)jp.getComponent(1);
        PanelLine pl = spl.getSelected();
        if (pl == null) {
            System.out.println("no graph selected");
            return null;
        }
        return (AbstractGraph)pl.getModel();
    }

    private ScrollPanelLine getSPL(JTabbedPane jtp, String name) {
        int noTab = jtp.indexOfTab(name);
        if (noTab == -1) {
            System.out.println("pas d'entree " + name);
            return null;
        }
        JPanel jp = (JPanel)jtp.getComponentAt(noTab);
        return (ScrollPanelLine)jp.getComponent(1);
    }

    private boolean addInJCB(JComboBox jcb, String entry) {
        int nbItem = jcb.getItemCount();
        for (int i = 0; i < nbItem; ++i) {
            if (!entry.equals((String)jcb.getItemAt(i))) continue;
            return false;
        }
        jcb.addItem(entry);
        return true;
    }

    private boolean removeInJCB(JComboBox jcb, String entry) {
        int nbItem = jcb.getItemCount();
        for (int i = 0; i < nbItem; ++i) {
            if (!entry.equals((String)jcb.getItemAt(i))) continue;
            jcb.removeItem(entry);
            return false;
        }
        return false;
    }

    private ScrollPanelLine newScrollLayerLine() {
        ScrollPanelLine sl = new ScrollPanelLine();
        JPanel info = new JPanel();
        info.setLayout(new BorderLayout());
        info.add((Component)new JLabel("Layer Name"), "West");
        info.add((Component)new JLabel("Visible"), "East");
        sl.setInfoPanel(info);
        return sl;
    }

    private ScrollPanelLine newScrollGraphLine() {
        ScrollPanelLine sl = new ScrollPanelLine();
        JPanel info = new JPanel();
        info.setLayout(new BorderLayout());
        info.add((Component)new JLabel("Graph Name"), "West");
        info.add((Component)new JLabel("Visible"), "East");
        sl.setInfoPanel(info);
        return sl;
    }

    public void actionPerformed(ActionEvent e) {
        JCheckBox jcb;
        Container parent;
        Object source = e.getSource();
        if (source instanceof JButton) {
            JButton jb = (JButton)source;
            if (!jb.getText().equalsIgnoreCase("")) {
                if (jb.getText().equalsIgnoreCase("^")) {
                    if (this.jtpMain.getTitleAt(this.jtpMain.getSelectedIndex()).equalsIgnoreCase("Views")) {
                        GLayer gl = this.getLayerSelected();
                        if (gl == null) {
                            return;
                        }
                        GView gv = this.lm.getView(this.jtpView.getTitleAt(this.jtpView.getSelectedIndex()));
                        this.moveUpLayerInView(gl, gv);
                    } else if (this.jtpMain.getTitleAt(this.jtpMain.getSelectedIndex()).equalsIgnoreCase("Layers")) {
                        AbstractGraph gg = this.getGraphSelected();
                        if (gg == null) {
                            return;
                        }
                        GLayer gl = this.lm.getLayer(this.jtpLayer.getTitleAt(this.jtpLayer.getSelectedIndex()));
                        this.moveUpGraphInLayer(gg, gl);
                    }
                } else if (jb.getText().equalsIgnoreCase("v")) {
                    if (this.jtpMain.getTitleAt(this.jtpMain.getSelectedIndex()).equalsIgnoreCase("Views")) {
                        GLayer gl = this.getLayerSelected();
                        if (gl == null) {
                            return;
                        }
                        GView gv = this.lm.getView(this.jtpView.getTitleAt(this.jtpView.getSelectedIndex()));
                        this.moveDownLayerInView(gl, gv);
                    } else if (this.jtpMain.getTitleAt(this.jtpMain.getSelectedIndex()).equalsIgnoreCase("Layers")) {
                        AbstractGraph gg = this.getGraphSelected();
                        if (gg == null) {
                            return;
                        }
                        GLayer gl = this.lm.getLayer(this.jtpLayer.getTitleAt(this.jtpLayer.getSelectedIndex()));
                        this.moveDownGraphInLayer(gg, gl);
                    }
                } else if (jb.getText().equalsIgnoreCase("X")) {
                    if (this.jtpMain.getTitleAt(this.jtpMain.getSelectedIndex()).equalsIgnoreCase("Views")) {
                        GLayer gl = this.getLayerSelected();
                        if (gl == null) {
                            return;
                        }
                        GView gv = this.lm.getView(this.jtpView.getTitleAt(this.jtpView.getSelectedIndex()));
                        this.removeLayerInView(gl, gv);
                    } else if (this.jtpMain.getTitleAt(this.jtpMain.getSelectedIndex()).equalsIgnoreCase("Layers")) {
                        AbstractGraph gg = this.getGraphSelected();
                        if (gg == null) {
                            return;
                        }
                        GLayer gl = this.lm.getLayer(this.jtpLayer.getTitleAt(this.jtpLayer.getSelectedIndex()));
                        this.removeGraphInLayer(gg, gl);
                    }
                } else if (jb.getText().equalsIgnoreCase("New View")) {
                    this.newView();
                } else if (jb.getText().equalsIgnoreCase("New Editor")) {
                    this.newEditor();
                }
            }
        } else if (source instanceof JCheckBox && (parent = (jcb = (JCheckBox)source).getParent()) instanceof PanelLine) {
            Object model = ((PanelLine)parent).getModel();
            if (model instanceof GLayer) {
                GLayer gl = (GLayer)model;
                GView gv = this.lm.getView(this.jtpView.getTitleAt(this.jtpView.getSelectedIndex()));
                this.setVisibleLayerInView(gl, gv, jcb.isSelected());
            } else if (model instanceof AbstractGraph) {
                AbstractGraph ag = (AbstractGraph)model;
                GLayer gl = this.lm.getLayer(this.jtpLayer.getTitleAt(this.jtpLayer.getSelectedIndex()));
                this.setVisibleGraphInLayer(ag, gl, jcb.isSelected());
            }
        }
    }

    public void purgeUnusedGraphs() {
        Vector<AbstractGraph> graphsHavingAnEntry = new Vector<AbstractGraph>();
        Iterator itLayers = this.lm.getLayers().iterator();
        while (itLayers.hasNext()) {
            GLayer layer = (GLayer)itLayers.next();
            ScrollPanelLine spl = this.getSPL(this.jtpLayer, layer.getName());
            JPanel jp = spl.getPanels();
            for (int i = 0; i < jp.getComponentCount(); ++i) {
                PanelLine pl = (PanelLine)jp.getComponent(i);
                AbstractGraph g = (AbstractGraph)pl.getModel();
                graphsHavingAnEntry.add(g);
            }
        }
        Vector graphsRemoved = this.lm.purgeUnusedGraphs(graphsHavingAnEntry);
        Iterator itGraphs = graphsRemoved.iterator();
        while (itGraphs.hasNext()) {
            String name = (String)itGraphs.next();
            this.removeInJCB(this.jcbAddGraph, name);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        JComboBox jcb = (JComboBox)e.getItemSelectable();
        if (e.getStateChange() == 1) {
            if (e.getItem() == jcb.getItemAt(0)) {
                return;
            }
            String selected = (String)e.getItem();
            jcb.setSelectedIndex(0);
            if (jcb == this.jcbAddLayer) {
                this.jtpMain.setSelectedIndex(this.jtpMain.indexOfTab("VIEWS"));
                GView gv = this.lm.getView(this.jtpView.getTitleAt(this.jtpView.getSelectedIndex()));
                GLayer gl = this.lm.getLayer(selected);
                if (selected.equalsIgnoreCase("new layer")) {
                    this.addLayerInView(this.newLayer("New Layer'"), gv);
                } else {
                    this.addLayerInView(gl, gv);
                }
            } else if (jcb == this.jcbAddGraph) {
                this.jtpMain.setSelectedIndex(this.jtpMain.indexOfTab("LAYERS"));
                if (selected.equalsIgnoreCase("Scan File")) {
                    MGLReader reader = GraphChooser.getMGLReader();
                    if (reader == null) {
                        return;
                    }
                    try {
                        reader.parse();
                    }
                    catch (Exception exc) {
                        System.err.println("Error when scanning file !");
                    }
                    Iterator graphs = reader.getAbstractGraphs();
                    while (graphs.hasNext()) {
                        this.newGraph((AbstractGraph)graphs.next());
                    }
                    graphs = reader.getAbstractGraphs();
                    String sumup = "Graphs added :\n";
                    while (graphs.hasNext()) {
                        sumup = sumup + "  => " + ((AbstractGraph)graphs.next()).getName() + "\n";
                    }
                    JOptionPane.showMessageDialog(this, sumup, "info", 1);
                    Iterator paths = reader.getAbstractChains();
                    while (paths.hasNext()) {
                        this.newGraph((AbstractGraph)paths.next());
                    }
                    paths = reader.getAbstractChains();
                    sumup = "Paths added :\n";
                    while (paths.hasNext()) {
                        sumup = sumup + "  => " + ((AbstractGraph)paths.next()).getName() + "\n";
                    }
                    JOptionPane.showMessageDialog(this, sumup, "info", 1);
                } else {
                    GLayer gl = this.lm.getLayer(this.jtpLayer.getTitleAt(this.jtpLayer.getSelectedIndex()));
                    AbstractGraph graph = this.lm.getGraph(selected);
                    this.addGraphInLayer(graph, gl, true);
                }
            }
        }
    }
}

