/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mascoptLib.gui.PanelLine;

class ScrollPanelLine
extends JPanel
implements MouseListener {
    JPanel jpMain;
    JPanel info;
    PanelLine llSelected;

    public ScrollPanelLine() {
        this.setLayout(new BorderLayout());
        this.jpMain = new JPanel();
        this.jpMain.setLayout(new BoxLayout(this.jpMain, 1));
        JScrollPane scrollPane = new JScrollPane(this.jpMain);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.add((Component)scrollPane, "Center");
        this.info = new JPanel();
        this.info.setLayout(new BorderLayout());
        this.info.add((Component)new JLabel("Name"), "West");
        this.info.add((Component)new JLabel("Visible"), "East");
        this.add((Component)this.info, "North");
        this.jpMain.addMouseListener(this);
    }

    public void setInfoPanel(JPanel jpInfo) {
        super.remove(this.info);
        this.add((Component)jpInfo, "North");
    }

    public JPanel getPanels() {
        return this.jpMain;
    }

    public void addPanelLine(PanelLine pl) {
        this.jpMain.add(pl);
    }

    public void selectPanelLine(PanelLine ll) {
        if (this.llSelected != null) {
            this.llSelected.unslect();
        }
        this.llSelected = ll;
        ll.select();
    }

    public PanelLine getSelected() {
        return this.llSelected;
    }

    public void moveUpSelected() {
        if (this.llSelected != null) {
            this.moveUp(this.llSelected);
        }
    }

    public void moveDownSelected() {
        if (this.llSelected != null) {
            this.moveDown(this.llSelected);
        }
    }

    public void removeSelected() {
        if (this.llSelected != null) {
            this.remove(this.llSelected);
        }
    }

    public void moveUp(PanelLine ll) {
        int no = this.getIndex(ll);
        if (no == 0) {
            return;
        }
        this.jpMain.remove(no);
        this.jpMain.add((Component)ll, no - 1);
    }

    public void moveDown(PanelLine ll) {
        int no = this.getIndex(ll);
        if (no == this.jpMain.getComponentCount() - 1) {
            return;
        }
        this.jpMain.remove(no);
        this.jpMain.add((Component)ll, no + 1);
    }

    public void remove(PanelLine ll) {
        int no = this.getIndex(ll);
        if (no != -1) {
            this.jpMain.remove(no);
        }
    }

    public void moveUp(Object model) {
        this.moveUp(this.getPanelLine(model));
    }

    public void moveDown(Object model) {
        this.moveDown(this.getPanelLine(model));
    }

    public void remove(Object model) {
        this.remove(this.getPanelLine(model));
        if (model == this.llSelected) {
            this.llSelected = null;
        }
    }

    public void setVisible(Object model, boolean visible) {
        PanelLine pl = this.getPanelLine(model);
        if (pl == null) {
            System.out.println("panel line not found");
            return;
        }
        pl.setVisibleModel(visible);
    }

    protected PanelLine getPanelLine(Object model) {
        int nbLines = this.jpMain.getComponentCount();
        for (int i = 0; i < nbLines; ++i) {
            PanelLine pl = (PanelLine)this.jpMain.getComponent(i);
            if (pl.getModel() != model) continue;
            return pl;
        }
        return null;
    }

    private int getIndex(PanelLine ll) {
        Component[] comps = this.jpMain.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != ll) continue;
            return i;
        }
        return -1;
    }

    public void mouseClicked(MouseEvent e) {
        Component c = this.jpMain.getComponentAt(e.getPoint());
        if (c == null) {
            return;
        }
        if (c instanceof PanelLine) {
            this.selectPanelLine((PanelLine)c);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

