/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractEdgeSet;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.AbstractVertexSet;
import mascoptLib.graphs.ArcSet;
import mascoptLib.graphs.DiGraph;
import mascoptLib.graphs.EdgeSet;
import mascoptLib.graphs.Graph;
import mascoptLib.graphs.VertexSet;
import mascoptLib.gui.GLayer;
import mascoptLib.gui.GView;
import mascoptLib.gui.GraphChooser;
import mascoptLib.gui.ThemeManager;
import mascoptLib.gui.TypEdListener;
import mascoptLib.io.graph.MGLWriter;
import mascoptLib.util.Util;

public class TypEd
extends JPanel
implements ActionListener {
    private static int NO = 0;
    TypEdListener tel;
    AbstractGraph graphEdited;
    GLayer gl;
    GView gv;
    JPanel title;
    JCheckBox jcbShowLabels;
    Cursor removeC;
    Cursor colorC;
    String oldX = "0";
    String oldY = "0";

    public TypEd() {
        ThemeManager tm = new ThemeManager();
        tm.setTheme();
        this.tel = new TypEdListener();
        this.gv = new GView("EDITOR", 200, 200, 1.0);
        this.gv.addMouseMotionListener(this.tel);
        this.gv.addMouseListener(this.tel);
        this.gv.addMouseWheelListener(this.tel);
        this.gl = new GLayer("LAYER_EDITOR", this.tel);
        this.gv.addLayer(this.gl);
        this.title = new JPanel();
        this.title.setLayout(new BoxLayout(this.title, 1));
        this.title.add(new JLabel("Click on new Graph, new DiGraph or load to start"));
        this.createViewFrame(this.gv, 400, 400, 350, 10, this.title);
        this.tel.setLayer(this.gl);
        JPanel news = new JPanel();
        JButton jbNewGraph = new JButton("New Graph");
        jbNewGraph.addActionListener(this);
        JButton jbNewDiGraph = new JButton("New DiGraph");
        jbNewDiGraph.addActionListener(this);
        JButton jbLoad = new JButton("Load");
        jbLoad.addActionListener(this);
        JButton jbSave = new JButton("Save");
        jbSave.addActionListener(this);
        JButton jbNewView = new JButton("New View");
        jbNewView.addActionListener(this);
        news.add(jbNewGraph);
        news.add(jbNewDiGraph);
        news.add(jbLoad);
        news.add(jbSave);
        news.add(jbNewView);
        JPanel actions = new JPanel();
        ButtonGroup group = new ButtonGroup();
        JRadioButton jbCreate = new JRadioButton("Create", true);
        jbCreate.addActionListener(this);
        JRadioButton jbDestroy = new JRadioButton("X");
        jbDestroy.addActionListener(this);
        JRadioButton jbSetName = new JRadioButton("Set Name");
        jbSetName.addActionListener(this);
        JRadioButton jbSetColor = new JRadioButton("Set Color");
        jbSetColor.addActionListener(this);
        JRadioButton jbSetValue = new JRadioButton("Set Value");
        jbSetValue.addActionListener(this);
        group.add(jbCreate);
        group.add(jbDestroy);
        group.add(jbSetName);
        group.add(jbSetColor);
        group.add(jbSetValue);
        JButton jbInsert = new JButton("Insert Graph");
        jbInsert.addActionListener(this);
        JButton jbDump = new JButton("Dump");
        jbDump.addActionListener(this);
        actions.add(jbCreate);
        actions.add(jbDestroy);
        actions.add(jbSetName);
        actions.add(jbSetColor);
        actions.add(jbSetValue);
        actions.add(jbInsert);
        actions.add(jbDump);
        JPanel labels = new JPanel();
        this.jcbShowLabels = new JCheckBox("show Labels");
        this.jcbShowLabels.addActionListener(this);
        JButton jbSetNodeLabel = new JButton("Set Node Label");
        jbSetNodeLabel.addActionListener(this);
        JButton jbSetArcLabel = new JButton("Set Arc Label");
        jbSetArcLabel.addActionListener(this);
        labels.add(this.jcbShowLabels);
        labels.add(jbSetNodeLabel);
        labels.add(jbSetArcLabel);
        this.setLayout(new BorderLayout());
        this.add((Component)news, "North");
        this.add((Component)actions, "Center");
        this.add((Component)labels, "South");
        this.showLabels(true);
        String racine = Util.getPathInClassPath("mascoptLib.jar") + "image/";
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.removeC = tk.createCustomCursor(tk.createImage(racine + "skull.gif"), new Point(4, 4), "dead");
        this.colorC = tk.createCustomCursor(tk.createImage(racine + "palette.gif"), new Point(4, 4), "color");
    }

    public void editGraph(AbstractGraph g) {
        if (this.graphEdited != null) {
            this.gl.removeGraph(this.graphEdited);
        }
        this.graphEdited = g;
        this.gl.addGraph(g);
        this.gl.setNodeLabel(g, new String[]{"$(name)"});
        this.gl.setArcLabel(g, new String[]{"$(name)"});
        this.tel.setGraph(g);
        this.title.removeAll();
        this.gv.repaint();
    }

    public void newView() {
        GView vv = new GView("EDITOR #" + ++NO, 200, 200, 1.0);
        vv.addMouseMotionListener(this.tel);
        vv.addMouseListener(this.tel);
        vv.addLayer(this.gl);
        this.createViewFrame(vv, 400, 400, 350, 10, null);
    }

    private GView createViewFrame(GView v, int w, int h, int xLocation, int yLocation, JPanel title) {
        JFrame jfView = new JFrame(v.getName());
        JPanel jpM = new JPanel();
        jpM.setLayout(new BorderLayout());
        if (title != null) {
            jpM.add((Component)title, "North");
        }
        jpM.add((Component)v, "Center");
        jfView.getContentPane().add(jpM);
        v.setPreferredSize(new Dimension(w, h));
        jfView.pack();
        jfView.setLocation(xLocation, yLocation);
        jfView.setVisible(true);
        return v;
    }

    public void newGraph() {
        VertexSet ns = new VertexSet();
        EdgeSet es = new EdgeSet(ns);
        Graph g = new Graph(ns, es);
        this.editGraph(g);
    }

    public void newDiGraph() {
        VertexSet ns = new VertexSet();
        ArcSet as = new ArcSet(ns);
        DiGraph dg = new DiGraph(ns, as);
        this.editGraph(dg);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof AbstractButton) {
            AbstractButton jb = (AbstractButton)source;
            if (jb.getText().equalsIgnoreCase("New Graph")) {
                this.newGraph();
            } else if (jb.getText().equalsIgnoreCase("New DiGraph")) {
                this.newDiGraph();
            } else if (jb.getText().equalsIgnoreCase("New View")) {
                this.newView();
            } else if (jb.getText().equalsIgnoreCase("Create")) {
                this.tel.setAction(TypEdListener.CREATE);
                this.gv.setCursor(new Cursor(0));
            } else if (jb.getText().equalsIgnoreCase("X")) {
                this.tel.setAction(TypEdListener.DESTROY);
                this.gv.setCursor(this.removeC);
            } else if (jb.getText().equalsIgnoreCase("Set Value")) {
                this.tel.setAction(TypEdListener.SET_VALUE);
                this.gv.setCursor(new Cursor(2));
            } else if (jb.getText().equalsIgnoreCase("Set Color")) {
                this.tel.setAction(TypEdListener.SET_COLOR);
                this.gv.setCursor(this.colorC);
            } else if (jb.getText().equalsIgnoreCase("Set Name")) {
                this.tel.setAction(TypEdListener.SET_NAME);
                this.gv.setCursor(new Cursor(2));
            } else if (jb.getText().equalsIgnoreCase("Insert Graph")) {
                this.insertGraph();
            } else if (jb.getText().equalsIgnoreCase("Save")) {
                this.writeGraph();
            } else if (jb.getText().equalsIgnoreCase("Load")) {
                this.loadGraph();
            } else if (jb.getText().equalsIgnoreCase("Dump")) {
                this.dumpGraph();
            } else if (jb.getText().equalsIgnoreCase("Set Node Label")) {
                this.setNodeLabel();
            } else if (jb.getText().equalsIgnoreCase("Set Arc Label")) {
                this.setArcLabel();
            } else if (jb.getText().equalsIgnoreCase("Show Labels")) {
                JCheckBox jcb = (JCheckBox)source;
                this.showLabels(jcb.isSelected());
            }
        }
    }

    public void insertGraph() {
        Object[] message = new Object[3];
        JPanel jpX = new JPanel();
        JTextField jtfX = new JTextField(this.oldX, 5);
        jpX.add(new JLabel("X:"));
        jpX.add(jtfX);
        JPanel jpY = new JPanel();
        JTextField jtfY = new JTextField(this.oldY, 5);
        jpY.add(new JLabel("Y:"));
        jpY.add(jtfY);
        message[0] = new JLabel("Insert Graph at: ");
        message[1] = jpX;
        message[2] = jpY;
        JOptionPane.showMessageDialog(null, message, "Info", 1);
        this.oldX = jtfX.getText();
        this.oldY = jtfY.getText();
        double x = 0.0;
        double y = 0.0;
        try {
            x = Double.parseDouble(this.oldX);
            y = Double.parseDouble(this.oldY);
        }
        catch (NumberFormatException e) {
            System.out.println("les champs doivent etre numerique");
            return;
        }
        AbstractGraph ag = GraphChooser.getGraphMGL();
        if (ag != null) {
            if (this.graphEdited == null) {
                this.editGraph(ag);
            } else {
                AbstractVertexSet ans = this.graphEdited.getAbstractVertexSet();
                AbstractEdgeSet aes = this.graphEdited.getAbstractEdgeSet();
                Iterator it = ag.getAbstractVertexSet().iterator();
                while (it.hasNext()) {
                    AbstractVertex an = (AbstractVertex)it.next();
                    an.setX(an.getX() + x);
                    an.setY(an.getY() + y);
                    ans.add(an);
                }
                it = ag.getAbstractEdgeSet().iterator();
                while (it.hasNext()) {
                    aes.add((AbstractEdge)it.next());
                }
            }
        }
    }

    public void writeGraph() {
        String fileName = GraphChooser.getFileName("./", new String[]{"xml", "mgl"}, "mascopt files", "Save");
        if (fileName == null) {
            return;
        }
        try {
            MGLWriter xmlw = new MGLWriter(fileName);
            xmlw.add(this.graphEdited);
            xmlw.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadGraph() {
        String fileName = GraphChooser.getFileName("./", new String[]{"xml", "mgl"}, "mascopt files", "Load");
        if (fileName != null) {
            this.loadGraph(fileName);
        }
    }

    public void loadGraph(String fileName) {
        AbstractGraph ag = GraphChooser.getGraphMGL(fileName);
        if (ag == null) {
            JOptionPane.showMessageDialog(this, "No Graph in this file", "error", 0);
        } else {
            this.editGraph(ag);
        }
    }

    public void dumpGraph() {
        String fileName = GraphChooser.getFileName("./", new String[]{"png"}, "image files", "Save");
        if (fileName == null) {
            return;
        }
        try {
            BufferedImage bufferedImage = new BufferedImage(this.gv.getWidth(), this.gv.getHeight(), 1);
            Graphics2D g2d = bufferedImage.createGraphics();
            g2d.setColor(Color.lightGray);
            g2d.fillRect(0, 0, this.gv.getWidth(), this.gv.getHeight());
            this.gv.paint(g2d);
            g2d.dispose();
            if (!fileName.endsWith(".png") && !fileName.endsWith(".PNG")) {
                fileName = fileName + ".png";
            }
            File file = new File(fileName);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
            JOptionPane.showMessageDialog(this, "Done!", "done", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showLabels(boolean show) {
        this.jcbShowLabels.setSelected(show);
        this.gl.setVisibleLabels(this.graphEdited, show);
    }

    public void setNodeLabel() {
        if (this.graphEdited == null) {
            return;
        }
        String oldValue = this.line(this.gl.getNodeLabel(this.graphEdited));
        String newValue = JOptionPane.showInputDialog("Enter Node Label (lines are separated with \\n)", (Object)oldValue);
        if (newValue == null) {
            return;
        }
        this.gl.setNodeLabel(this.graphEdited, this.split(newValue));
    }

    public void setArcLabel() {
        if (this.graphEdited == null) {
            return;
        }
        String oldValue = this.line(this.gl.getArcLabel(this.graphEdited));
        String newValue = JOptionPane.showInputDialog("Enter Arc Label (lines are separated with \\n)", (Object)oldValue);
        if (newValue == null) {
            return;
        }
        this.gl.setArcLabel(this.graphEdited, this.split(newValue));
    }

    private String[] split(String line) {
        Vector<String> v = new Vector<String>();
        int length = line.length();
        if (length == 0) {
            return v.toArray(new String[0]);
        }
        boolean maybe = false;
        String currentLine = new String();
        for (int i = 0; i < length; ++i) {
            char c = line.charAt(i);
            if (c == '\\') {
                maybe = true;
                continue;
            }
            if (maybe) {
                if (c == 'n') {
                    v.add(currentLine);
                    currentLine = "";
                    maybe = false;
                    continue;
                }
                currentLine = currentLine + '\\';
            }
            currentLine = currentLine + c;
            maybe = false;
        }
        v.add(currentLine);
        String[] ret = new String[v.size()];
        return v.toArray(ret);
    }

    private String line(String[] in) {
        String ret = "";
        int length = in.length;
        if (length == 0) {
            return ret;
        }
        ret = in[0];
        for (int i = 1; i < length; ++i) {
            ret = ret + "\\n" + in[i];
        }
        return ret;
    }
}

