/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.views;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import mascoptLib.gui.views.GObject;
import mascoptLib.gui.views.Link;

public class ArrowedLink
extends Link {
    private boolean visibleArrow = true;
    private Polygon arrowPolygon;
    private int offsetAxis = 5;
    private int offsetNormal = 5;

    public ArrowedLink(GObject source, GObject target, Color color) {
        this(source, target, color, 0);
    }

    public ArrowedLink(GObject source, GObject target, Color color, int shift) {
        this(source, target, source.getWidth() / 2, source.getHeight() / 2, target.getWidth() / 2, target.getHeight() / 2, color, shift);
    }

    public ArrowedLink(GObject source, GObject target, int offSetSourceX, int offSetSourceY, int offSetTargetX, int offSetTargetY, Color color) {
        this(source, target, offSetSourceX, offSetSourceY, offSetTargetX, offSetTargetY, color, 0);
    }

    public ArrowedLink(GObject source, GObject target, int offSetSourceX, int offSetSourceY, int offSetTargetX, int offSetTargetY, Color color, int shift) {
        super(source, target, offSetSourceX, offSetSourceY, offSetTargetX, offSetTargetY, color, shift);
        this.setVisibleArrow(true);
        this.updateBounds();
    }

    public void setOffsetAxis(int v) {
        this.offsetAxis = v;
    }

    public void setOffsetNormal(int v) {
        this.offsetNormal = v;
    }

    public Point getCenterArrow() {
        return new Point(this.arrowPolygon.xpoints[1], this.arrowPolygon.ypoints[1]);
    }

    public void setVisibleArrow(boolean b) {
        this.visibleArrow = b;
    }

    protected void updateBounds() {
        this.MARGIN = Math.max(this.offsetNormal, this.offsetAxis);
        super.updateBounds();
        double X = this.realStart.x - this.realEnd.x;
        double Y = this.realStart.y - this.realEnd.y;
        double x2 = (double)this.offsetAxis * (X /= this.distance);
        double y2 = (double)this.offsetAxis * (Y /= this.distance);
        double Xi = (double)this.offsetNormal * X;
        double Yi = (double)this.offsetNormal * Y;
        int[] xp = new int[]{(int)Math.round(x2 - Yi + this.centerArrowX), (int)Math.round(this.centerArrowX), (int)Math.round(x2 + Yi + this.centerArrowX)};
        int[] yp = new int[]{(int)Math.round(y2 + Xi + this.centerArrowY), (int)Math.round(this.centerArrowY), (int)Math.round(y2 - Xi + this.centerArrowY)};
        this.arrowPolygon = new Polygon(xp, yp, 3);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.visibleArrow) {
            g.fillPolygon(this.arrowPolygon);
        }
    }

    public boolean contains(int x, int y) {
        if (super.contains(x, y)) {
            return true;
        }
        return this.arrowPolygon.contains((double)x, (double)y);
    }
}

