/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.views;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import mascoptLib.gui.views.GObject;
import mascoptLib.gui.views.View;

public class DefaultViewAdapter
extends MouseAdapter
implements MouseMotionListener,
MouseWheelListener {
    GObject currentDragged = null;
    Point draggOrigin = null;
    Cursor oldCursor = null;
    Cursor moveCursor = new Cursor(13);

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        Object source = e.getSource();
        if (source instanceof GObject) {
            this.currentDragged = (GObject)source;
            this.draggOrigin = e.getPoint();
            this.oldCursor = this.currentDragged.getCursor();
            this.currentDragged.setCursor(this.moveCursor);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.currentDragged != null) {
            this.currentDragged.repaint();
            if (this.oldCursor != null) {
                this.currentDragged.setCursor(this.oldCursor);
            }
        }
        this.currentDragged = null;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.currentDragged == null) {
            return;
        }
        if (this.currentDragged instanceof View) {
            View view = (View)this.currentDragged;
            Point realDraggOrigin = view.getReal(this.draggOrigin);
            Point realMousePoint = view.getReal(e.getPoint());
            int transX = realDraggOrigin.x - realMousePoint.x;
            int transY = realDraggOrigin.y - realMousePoint.y;
            this.currentDragged.translate(transX, transY);
            this.draggOrigin = e.getPoint();
        } else {
            this.currentDragged.translate(e.getX() - this.draggOrigin.x, e.getY() - this.draggOrigin.y);
            this.currentDragged.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        Object source = e.getSource();
        if (source instanceof View) {
            View view = (View)e.getSource();
            double speed = 1.0 - (double)e.getWheelRotation() * 0.1;
            view.updateZoom(speed);
            view.repaint();
        }
    }
}

