/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.views;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import mascoptLib.gui.views.GObject;

public class Label
extends GObject {
    private LabelListener labelListener = new LabelListener();
    private GObject source;
    private String[] lines;
    private double ratioX;
    private double ratioY;
    private Color color = Color.black;
    private Color colorBack = Color.black;
    private boolean transparent = false;
    Font font = null;
    private int ascent = 0;

    public Label(GObject source, String[] lines, double ratioX, double ratioY) {
        this(source, lines, ratioX, ratioY, Color.black);
    }

    public Label(GObject source, String[] lines, double ratioX, double ratioY, Color color) {
        this(source, lines, ratioX, ratioY, Color.black, new Color(230, 240, 240), false, 10);
    }

    public Label(GObject source, String[] lines, double ratioX, double ratioY, Color color, Color back, boolean transparent, int fontSize) {
        this.source = source;
        this.lines = lines;
        this.ratioX = ratioX;
        this.ratioY = ratioY;
        this.color = color;
        this.colorBack = back;
        this.transparent = transparent;
        this.font = new Font("Monospaced", 0, fontSize);
        source.addComponentListener(this.labelListener);
        this.updateBounds();
    }

    private String getMaxLine() {
        FontMetrics fm = this.source.getFontMetrics(this.font);
        String maxLine = "";
        for (int i = 0; i < this.lines.length; ++i) {
            if (fm.stringWidth(this.lines[i]) < fm.stringWidth(maxLine)) continue;
            maxLine = this.lines[i];
        }
        return maxLine;
    }

    protected void updateBounds() {
        int sourceWidth = this.source.getWidth();
        int sourceHeight = this.source.getHeight();
        Point sourceLocation = this.source.getLocation();
        FontMetrics fm = this.source.getFontMetrics(this.font);
        int h = fm.getAscent() * this.lines.length + fm.getDescent();
        int startX = sourceLocation.x + (int)Math.round(this.ratioX * (double)sourceWidth);
        int startY = sourceLocation.y + (int)Math.round(this.ratioY * (double)sourceHeight) - h;
        Rectangle bounds = new Rectangle(startX, startY, fm.stringWidth(this.getMaxLine() + "X"), h);
        this.ascent = fm.getAscent();
        this.setBounds(bounds);
        this.repaint();
    }

    public void setLocation(int x, int y) {
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    public void paint(Graphics g) {
        if (!this.transparent) {
            g.setColor(this.colorBack);
            Rectangle bg = this.getBounds();
            g.fill3DRect(1, 1, bg.width - 1, bg.height - 1, true);
        }
        g.setColor(this.color);
        g.setFont(this.font);
        for (int i = 0; i < this.lines.length; ++i) {
            g.drawString(this.lines[i], 2, this.ascent * (i + 1));
        }
    }

    class LabelListener
    extends ComponentAdapter {
        LabelListener() {
        }

        public void componentMoved(ComponentEvent e) {
            Label.this.updateBounds();
        }

        public void componentResized(ComponentEvent e) {
            Label.this.updateBounds();
        }
    }
}

