/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.views;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import mascoptLib.gui.views.GObject;
import mascoptLib.gui.views.View;

public class Layer {
    private Vector[] priorityObjects = new Vector[MAX_PRIORITY + 1];
    private static int MAX_PRIORITY = 5;
    private Vector views = new Vector();

    public void add(GObject comp) {
        this.add(comp, MAX_PRIORITY);
    }

    public void add(GObject comp, int priority) {
        if (priority < 0) {
            priority = 0;
        } else if (priority > MAX_PRIORITY) {
            priority = MAX_PRIORITY;
        }
        Vector<GObject> priorityLevel = this.priorityObjects[priority];
        if (priorityLevel == null) {
            this.priorityObjects[priority] = priorityLevel = new Vector<GObject>();
        }
        priorityLevel.add(comp);
        comp.addLayer(this);
    }

    public void remove(GObject comp) {
        for (int priority = 0; priority <= MAX_PRIORITY; ++priority) {
            this.remove(comp, priority);
        }
    }

    public boolean contains(GObject comp) {
        for (int priority = MAX_PRIORITY; priority >= 0; --priority) {
            Vector priorityLevel = this.priorityObjects[priority];
            if (priorityLevel == null || !priorityLevel.contains(comp)) continue;
            return true;
        }
        return false;
    }

    public void remove(GObject comp, int priority) {
        if (priority < 0) {
            priority = 0;
        } else if (priority > MAX_PRIORITY) {
            priority = MAX_PRIORITY;
        }
        Vector priorityLevel = this.priorityObjects[priority];
        if (priorityLevel != null) {
            priorityLevel.remove(comp);
            comp.removeLayer(this);
        }
    }

    public void addView(View v) {
        this.views.add(v);
    }

    public void removeView(View v) {
        this.views.remove(v);
    }

    public void repaint() {
        int nbViews = this.views.size();
        for (int i = 0; i < nbViews; ++i) {
            ((View)this.views.elementAt(i)).repaint();
        }
    }

    public Component getComponentAt(Point p) {
        for (int priority = MAX_PRIORITY; priority >= 0; --priority) {
            Vector priorityLevel = this.priorityObjects[priority];
            if (priorityLevel == null) continue;
            for (int i = 0; i < priorityLevel.size(); ++i) {
                Component component = (Component)priorityLevel.elementAt(i);
                Point location = component.getLocation();
                if (!component.contains(new Point(p.x - location.x, p.y - location.y))) continue;
                return component;
            }
        }
        return null;
    }

    public void paint(Graphics g, Rectangle view) {
        for (int priority = 0; priority <= MAX_PRIORITY; ++priority) {
            Vector priorityLevel = this.priorityObjects[priority];
            if (priorityLevel == null) continue;
            for (int i = 0; i < priorityLevel.size(); ++i) {
                Component component = (Component)priorityLevel.elementAt(i);
                Rectangle bounds = component.getBounds();
                if (!view.intersects(bounds)) continue;
                Graphics newG = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
                component.paint(newG);
            }
        }
    }
}

