/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.views;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.QuadCurve2D;
import mascoptLib.gui.views.GObject;

public class Link
extends GObject {
    private LinkListener linkListener = new LinkListener();
    protected GObject source;
    protected int offSetSourceX;
    protected int offSetSourceY;
    protected GObject target;
    protected int offSetTargetX;
    protected int offSetTargetY;
    protected int shift;
    protected Point realStart;
    protected Point realEnd;
    protected double centerArrowX;
    protected double centerArrowY;
    protected double controlPointX;
    protected double controlPointY;
    protected double distance;
    protected QuadCurve2D.Double curve;
    public Color color = Color.green;
    protected int MARGIN = 2;

    public Link(GObject source, GObject target, Color color) {
        this(source, target, color, 0);
    }

    public Link(GObject source, GObject target, Color color, int shift) {
        this(source, target, source.getWidth() / 2, source.getHeight() / 2, target.getWidth() / 2, target.getHeight() / 2, color, shift);
    }

    public Link(GObject source, GObject target, int offSetSourceX, int offSetSourceY, int offSetTargetX, int offSetTargetY, Color color) {
        this(source, target, offSetSourceX, offSetSourceY, offSetTargetX, offSetTargetY, color, 0);
    }

    public Link(GObject source, GObject target, int offSetSourceX, int offSetSourceY, int offSetTargetX, int offSetTargetY, Color color, int shift) {
        this.source = source;
        this.target = target;
        this.offSetSourceX = offSetSourceX;
        this.offSetSourceY = offSetSourceY;
        this.offSetTargetX = offSetTargetX;
        this.offSetTargetY = offSetTargetY;
        this.color = color;
        this.shift = shift;
        source.addComponentListener(this.linkListener);
        target.addComponentListener(this.linkListener);
        this.curve = new QuadCurve2D.Double();
        this.updateBounds();
    }

    protected void updateBounds() {
        Point sourceLocation = this.source.getLocation();
        Point targetLocation = this.target.getLocation();
        sourceLocation.translate(this.offSetSourceX, this.offSetSourceY);
        targetLocation.translate(this.offSetTargetX, this.offSetTargetY);
        double X = targetLocation.x - sourceLocation.x;
        double Y = targetLocation.y - sourceLocation.y;
        this.distance = Math.sqrt(X * X + Y * Y);
        int dx = 0;
        int dy = 0;
        if (this.distance != 0.0) {
            dx = -((int)Math.floor((double)this.shift * Y / this.distance));
            dy = (int)Math.floor((double)this.shift * X / this.distance);
        }
        int minX = sourceLocation.x < targetLocation.x ? sourceLocation.x : targetLocation.x;
        int minY = sourceLocation.y < targetLocation.y ? sourceLocation.y : targetLocation.y;
        Rectangle bounds = new Rectangle(minX - (this.MARGIN + this.shift), minY - (this.MARGIN + this.shift), Math.abs(sourceLocation.x - targetLocation.x) + 2 * (this.MARGIN + this.shift), Math.abs(sourceLocation.y - targetLocation.y) + 2 * (this.MARGIN + this.shift));
        this.setBounds(bounds);
        Point location = this.getLocation();
        sourceLocation.translate(-location.x, -location.y);
        targetLocation.translate(-location.x, -location.y);
        this.realStart = sourceLocation;
        this.realEnd = targetLocation;
        this.controlPointX = (long)(this.realStart.x + dx * 2) + Math.round(X / 2.0);
        this.controlPointY = (long)(this.realStart.y + dy * 2) + Math.round(Y / 2.0);
        this.centerArrowX = (long)(this.realStart.x + dx) + Math.round(X / 2.0);
        this.centerArrowY = (long)(this.realStart.y + dy) + Math.round(Y / 2.0);
        this.curve.setCurve(this.realStart.x, this.realStart.y, this.controlPointX, this.controlPointY, this.realEnd.x, this.realEnd.y);
    }

    public void setLocation(int x, int y) {
    }

    public GObject getSource() {
        return this.source;
    }

    public GObject getTarget() {
        return this.target;
    }

    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        return this.curve.contains(x, y) || this.curve.contains((double)x + 1.0, y) || this.curve.contains((double)x - 1.0, y) || this.curve.contains(x, (double)y + 2.0) || this.curve.contains(x, (double)y + 1.0);
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    public void setShift(int s) {
        this.shift = s;
        this.updateBounds();
    }

    public int getShift() {
        return this.shift;
    }

    public void paint(Graphics g) {
        g.setColor(this.color);
        ((Graphics2D)g).draw(this.curve);
    }

    class LinkListener
    extends ComponentAdapter {
        LinkListener() {
        }

        public void componentMoved(ComponentEvent e) {
            Link.this.updateBounds();
        }
    }
}

