/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.graph;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.ArcSet;
import mascoptLib.graphs.DiGraph;
import mascoptLib.graphs.Vertex;
import mascoptLib.graphs.VertexSet;
import mascoptLib.io.ReaderInterface;
import mascoptLib.util.Trace;

public class GodReader
implements ReaderInterface {
    private Vector abstractNodes;
    private Vector abstractEdges;
    private Vector abstractNodeSets;
    private Vector abstractEdgeSets;
    private Vector abstractChains;
    private Vector abstractGraphs;
    private int NO_LIGNE = 0;
    private BufferedReader reader;
    private BufferedReader reader2;
    private VertexSet nodeSet;
    protected ArcSet cables;
    private ArcSet demands;
    private boolean mirrorArc;
    private boolean mirrorRequest;

    public GodReader(String fileIn, String fileIn2) {
        this(fileIn, fileIn2, false, false);
    }

    public GodReader(String fileIn, String fileIn2, boolean mirrorArc, boolean mirrorRequest) {
        Trace.println("new reader");
        this.mirrorArc = mirrorArc;
        this.mirrorRequest = mirrorRequest;
        this.abstractNodes = new Vector();
        this.abstractEdges = new Vector();
        this.abstractNodeSets = new Vector();
        this.abstractEdgeSets = new Vector();
        this.abstractGraphs = new Vector();
        try {
            this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileIn)));
            this.reader2 = new BufferedReader(new InputStreamReader(new FileInputStream(fileIn2)));
        }
        catch (Exception e) {
            System.out.println("Error opening file " + fileIn);
            return;
        }
        this.nodeSet = new VertexSet();
        this.abstractNodeSets.add(this.nodeSet);
        this.cables = new ArcSet(this.nodeSet);
        this.demands = new ArcSet(this.nodeSet);
        this.abstractEdgeSets.add(this.cables);
        this.abstractEdgeSets.add(this.demands);
        DiGraph cableG = new DiGraph(this.nodeSet, this.cables);
        cableG.setName("graph Cable");
        this.abstractGraphs.add(cableG);
        DiGraph requestG = new DiGraph(this.nodeSet, this.demands);
        requestG.setName("graph Request");
        this.abstractGraphs.add(requestG);
        this.read();
    }

    private void read() {
        int nodeTo;
        int nodeFrom;
        String flag;
        StringTokenizer st;
        String line;
        while ((line = this.getLine(this.reader)) != null) {
            if (line.trim().length() == 0) continue;
            st = new StringTokenizer(line, " \t");
            flag = st.nextToken();
            if (flag.equals("n")) {
                int nbNodes = Integer.parseInt(st.nextToken());
                for (int i = 0; i < nbNodes; ++i) {
                    Vertex n = new Vertex(0.0, 0.0);
                    this.nodeSet.add(n);
                    this.abstractNodes.add(n);
                }
            }
            if (!flag.equals("e")) continue;
            nodeFrom = Integer.parseInt(st.nextToken());
            nodeTo = Integer.parseInt(st.nextToken());
            Vertex from = (Vertex)this.abstractNodes.elementAt(nodeFrom);
            Vertex to = (Vertex)this.abstractNodes.elementAt(nodeTo);
            Arc a = new Arc(from, to);
            this.cables.add(a);
            this.abstractEdges.add(a);
            if (!this.mirrorArc) continue;
            Arc aReverse = new Arc(to, from);
            this.cables.add(aReverse);
            this.abstractEdges.add(aReverse);
        }
        while ((line = this.getLine(this.reader2)) != null) {
            if (line.trim().length() == 0 || !(flag = (st = new StringTokenizer(line, " \t")).nextToken()).equals("r")) continue;
            nodeFrom = Integer.parseInt(st.nextToken());
            nodeTo = Integer.parseInt(st.nextToken());
            int capa = Integer.parseInt(st.nextToken());
            Vertex from = (Vertex)this.abstractNodes.elementAt(nodeFrom);
            Vertex to = (Vertex)this.abstractNodes.elementAt(nodeTo);
            Arc a = new Arc(from, to);
            a.setIntegerValue("request_size", new Integer(capa));
            this.demands.add(a);
            this.abstractEdges.add(a);
            if (!this.mirrorRequest) continue;
            Arc aRev = new Arc(to, from);
            aRev.setIntegerValue("request_size", new Integer(capa));
            this.demands.add(aRev);
            this.abstractEdges.add(aRev);
        }
    }

    private String getLine(BufferedReader br) {
        ++this.NO_LIGNE;
        String newL = "";
        while (newL.equals("")) {
            try {
                newL = br.readLine();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (newL == null) {
                return null;
            }
            if (!newL.startsWith("//") && !newL.trim().equals("")) continue;
            newL = "";
            ++this.NO_LIGNE;
        }
        return newL;
    }

    public Iterator getAbstractNodes() {
        return this.abstractNodes.iterator();
    }

    public Iterator getAbstractVertices() {
        return this.abstractNodes.iterator();
    }

    public Iterator getAbstractEdges() {
        return this.abstractEdges.iterator();
    }

    public Iterator getAbstractNodeSets() {
        return this.abstractNodeSets.iterator();
    }

    public Iterator getAbstractVertexSets() {
        return this.abstractNodeSets.iterator();
    }

    public Iterator getAbstractEdgeSets() {
        return this.abstractEdgeSets.iterator();
    }

    public Iterator getAbstractEdgeSetRequest() {
        return this.demands.iterator();
    }

    public Iterator getAbstractChains() {
        return this.abstractChains.iterator();
    }

    public Iterator getAbstractPaths() {
        return this.abstractChains.iterator();
    }

    public Iterator getAbstractGraphs() {
        return this.abstractGraphs.iterator();
    }

    public Iterator getAllObjects() {
        Vector ret = new Vector();
        ret.addAll(this.abstractNodes);
        ret.addAll(this.abstractEdges);
        ret.addAll(this.abstractNodeSets);
        ret.addAll(this.abstractEdgeSets);
        ret.addAll(this.abstractChains);
        ret.addAll(this.abstractGraphs);
        return ret.iterator();
    }
}

