/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.graph;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractEdgeSet;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.AbstractVertexSet;
import mascoptLib.abstractGraph.MascoptObject;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.ArcSet;
import mascoptLib.io.WriterInterface;

public class GodWriter
implements WriterInterface {
    private HashMap abstractNodeTable = new HashMap();
    private HashMap abstractNodeTable2 = new HashMap();
    private HashMap abstractEdgeTable = new HashMap();
    private HashMap abstractEdgeTable2 = new HashMap();
    private OutputStream osg;
    private OutputStream osr;

    public GodWriter(String file_graph, String file_request) throws FileNotFoundException {
        this(new FileOutputStream(file_graph), new FileOutputStream(file_request));
    }

    public GodWriter(OutputStream osg, OutputStream osr) {
        this.osg = osg;
        this.osr = osr;
    }

    public void add(MascoptObject object) {
        if (object instanceof AbstractVertex) {
            this.addAbstractNode((AbstractVertex)object);
        } else if (object instanceof AbstractEdge) {
            this.addAbstractEdge((AbstractEdge)object);
        } else if (object instanceof AbstractVertexSet) {
            this.addAbstractNodeSet((AbstractVertexSet)object);
        } else if (object instanceof AbstractEdgeSet) {
            this.addAbstractEdgeSet((AbstractEdgeSet)object);
        } else if (object instanceof AbstractGraph) {
            this.addAbstractGraph((AbstractGraph)object);
        } else {
            System.out.println("Object " + object + " unknown");
        }
    }

    private void addAbstractNode(AbstractVertex node) {
        this.abstractNodeTable.put(node.getId(), node);
    }

    private void addAbstractEdge(AbstractEdge abstractEdge) {
        this.abstractEdgeTable.put(abstractEdge.getId(), abstractEdge);
        AbstractVertex[] abstractNode = abstractEdge.getAbstractVertices();
        this.add(abstractNode[0]);
        this.add(abstractNode[1]);
    }

    private void addAbstractEdgeRequest(AbstractEdge abstractEdge) {
        this.abstractEdgeTable2.put(abstractEdge.getId(), abstractEdge);
    }

    public void addAbstractEdgeSetRequest(ArcSet arcSet) {
        Iterator abstractEdges = arcSet.iterator();
        while (abstractEdges.hasNext()) {
            this.addAbstractEdgeRequest((Arc)abstractEdges.next());
        }
    }

    private void addAbstractNodeSet(AbstractVertexSet abstractNodeSet) {
        Iterator abstractNodes = abstractNodeSet.iterator();
        while (abstractNodes.hasNext()) {
            this.add((AbstractVertex)abstractNodes.next());
        }
    }

    private void addAbstractEdgeSet(AbstractEdgeSet abstractEdgeSet) {
        Iterator abstractEdges = abstractEdgeSet.iterator();
        while (abstractEdges.hasNext()) {
            this.add((AbstractEdge)abstractEdges.next());
        }
    }

    private void addAbstractGraph(AbstractGraph abstractGraph) {
        this.add(abstractGraph.getAbstractVertexSet());
        this.add(abstractGraph.getAbstractEdgeSet());
    }

    public void write() {
        PrintStream ps = new PrintStream(this.osg);
        ps.println("n " + this.abstractNodeTable.size());
        Iterator iterator = this.abstractNodeTable.values().iterator();
        int compteur = 0;
        while (iterator.hasNext()) {
            this.abstractNodeTable2.put((AbstractVertex)iterator.next(), new Integer(compteur));
            ++compteur;
        }
        iterator = this.abstractEdgeTable.values().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            AbstractEdge edge = (AbstractEdge)object;
            AbstractVertex[] an = edge.getAbstractVertices();
            ps.println("e " + (Integer)this.abstractNodeTable2.get(an[0]) + " " + (Integer)this.abstractNodeTable2.get(an[1]));
        }
        PrintStream pso = new PrintStream(this.osr);
        pso.println("n " + this.abstractNodeTable.size());
        iterator = this.abstractEdgeTable2.values().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            AbstractEdge edge = (AbstractEdge)object;
            AbstractVertex[] an = edge.getAbstractVertices();
            pso.println("r " + (Integer)this.abstractNodeTable2.get(an[0]) + " " + (Integer)this.abstractNodeTable2.get(an[1]) + " " + edge.getIntegerValue("request_size"));
        }
    }
}

