/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.graph;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.SinglePropertyMap;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.xml.sax.Sax2XMLReaderCreator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import mascoptLib.abstractGraph.MascoptObject;
import mascoptLib.abstractGraph.MascoptObjectInterface;
import mascoptLib.abstractGraph.MascoptSet;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.ArcSet;
import mascoptLib.graphs.DiGraph;
import mascoptLib.graphs.DiGraphSet;
import mascoptLib.graphs.DiPath;
import mascoptLib.graphs.DiPathSet;
import mascoptLib.graphs.Edge;
import mascoptLib.graphs.EdgeSet;
import mascoptLib.graphs.Graph;
import mascoptLib.graphs.GraphSet;
import mascoptLib.graphs.Path;
import mascoptLib.graphs.PathSet;
import mascoptLib.graphs.Vertex;
import mascoptLib.graphs.VertexSet;
import mascoptLib.io.ReaderInterface;
import mascoptLib.io.graph.MGLEntityResolver;
import mascoptLib.io.graph.MGLNodeFilter;
import mascoptLib.io.graph.MGLWriter;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.SAXParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class MGLReader
implements ReaderInterface {
    private boolean validate = true;
    private String nameofstream;
    private InputStream streamtoparse;
    protected MGLNodeFilter nodefilter;
    private Document doc;
    protected Vector abstractVertexVector;
    protected Vector abstractEdgeVector;
    protected Vector abstractVertexSetVector;
    protected Vector abstractEdgeSetVector;
    protected Vector abstractPathVector;
    protected Vector abstractGraphVector;
    protected Vector abstractPathSetVector;
    protected Vector abstractGraphSetVector;

    public MGLReader(String streamname) throws FileNotFoundException, SecurityException {
        this.constructorHelper(streamname, true, new MGLNodeFilter());
    }

    public MGLReader(String streamname, boolean validate) throws FileNotFoundException, SecurityException {
        this.constructorHelper(streamname, validate, new MGLNodeFilter());
    }

    public MGLReader(String streamname, boolean validate, MGLNodeFilter customnodefilter) throws FileNotFoundException, SecurityException {
        this.constructorHelper(streamname, validate, customnodefilter);
    }

    private void constructorHelper(String streamname, boolean validate, MGLNodeFilter customnodefilter) throws FileNotFoundException, SecurityException {
        this.nameofstream = streamname;
        StringTokenizer st = new StringTokenizer(streamname, ":");
        try {
            this.streamtoparse = st.nextToken().equals("file") ? new FileInputStream(streamname.substring(6)) : new FileInputStream(streamname);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
        this.validate = validate;
        this.nodefilter = customnodefilter;
        this.doc = null;
    }

    public void parse() throws Exception {
        System.out.println("Starting XML parser");
        System.out.println("Reading " + this.nameofstream);
        Document doc = this.getDocument(this.streamtoparse);
        if (doc == null) {
            System.err.println("Error parsing file !");
        }
        this.abstractVertexVector = new Vector();
        this.abstractEdgeVector = new Vector();
        this.abstractVertexSetVector = new Vector();
        this.abstractEdgeSetVector = new Vector();
        this.abstractPathVector = new Vector();
        this.abstractGraphVector = new Vector();
        this.abstractPathSetVector = new Vector();
        this.abstractGraphSetVector = new Vector();
        DocumentTraversal traversable = (DocumentTraversal)((Object)doc);
        NodeIterator iterator = traversable.createNodeIterator(doc, -1, this.nodefilter, true);
        this.createObjects(iterator);
        doc = null;
    }

    private Document getDocument(InputStream in) {
        InputSource source = new InputSource(in);
        DOMParser parser = null;
        try {
            parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setEntityResolver((EntityResolver)new MGLEntityResolver());
        }
        catch (DOMException e) {
            System.out.println("Error while creating parser: " + e);
            return null;
        }
        catch (SAXNotRecognizedException e) {
            System.out.println("Error while creating parser: " + e);
            return null;
        }
        catch (SAXNotSupportedException e) {
            System.out.println("Error while creating parser: " + e);
            return null;
        }
        try {
            System.out.println("Parsing MGL file...");
            parser.parse(source);
        }
        catch (DOMException e) {
            System.out.println("Error while parsing: " + e);
        }
        catch (IOException e) {
            System.out.println("Error while parsing: " + e);
        }
        catch (SAXException e) {
            System.out.println("Error while parsing: " + e);
        }
        this.doc = parser.getDocument();
        System.out.println("Parsing done.");
        if (this.validate) {
            Node node = this.doc.getElementsByTagName(MGLWriter.rootElementForXMLFile).item(0);
            NamedNodeMap attributes = node.getAttributes();
            Node version_node = attributes.getNamedItem(MGLWriter.relaxNGVersionAttribute);
            if (version_node != null) {
                String version = version_node.getNodeValue();
                this.validateRelaxNG(version, parser);
            } else {
                System.out.println("No version found in tag OBJECTS for Relax NG validation.");
            }
        }
        return this.doc;
    }

    protected void validateRelaxNG(String version, DOMParser parser) {
        System.out.println("Validating with Relax NG schema... ");
        InputSource to_validate = null;
        try {
            to_validate = new InputSource(new FileInputStream(this.nameofstream));
        }
        catch (FileNotFoundException e1) {
            System.err.println("Error in Relax NG Validator: impossible to load file to validate. " + e1);
        }
        SinglePropertyMap property = new SinglePropertyMap((PropertyId)ValidateProperty.XML_READER_CREATOR, (Object)new mySax2XMLReaderCreator());
        ValidationDriver validator = new ValidationDriver((PropertyMap)property);
        MGLEntityResolver resolver = new MGLEntityResolver();
        InputSource relaxng = resolver.resolveEntity("", version);
        try {
            validator.loadSchema(relaxng);
            validator.validate(to_validate);
        }
        catch (SAXException e1) {
            System.err.println("Error in Relax NG Validator: validating error: " + e1);
        }
        catch (IOException e1) {
            System.err.println("Error in Relax NG Validator: file not found: " + e1);
        }
        System.out.println("Validation done.");
    }

    public Iterator getAbstractPaths() {
        return this.abstractPathVector.iterator();
    }

    public Iterator getAbstractChains() {
        return this.abstractPathVector.iterator();
    }

    public Iterator getAbstractEdges() {
        return this.abstractEdgeVector.iterator();
    }

    public Iterator getAbstractEdgeSets() {
        return this.abstractEdgeSetVector.iterator();
    }

    public Iterator getAbstractGraphs() {
        return this.abstractGraphVector.iterator();
    }

    public Iterator getAbstractVertices() {
        return this.abstractVertexVector.iterator();
    }

    public Iterator getAbstractVertexSets() {
        return this.abstractVertexSetVector.iterator();
    }

    public Iterator getAllObjects() {
        Collection all = (Collection)this.abstractVertexVector.clone();
        all.addAll(this.abstractEdgeVector);
        all.addAll(this.abstractVertexSetVector);
        all.addAll(this.abstractEdgeSetVector);
        all.addAll(this.abstractPathVector);
        all.addAll(this.abstractGraphVector);
        return all.iterator();
    }

    protected void createObjects(NodeIterator nodeiterator) {
        Node currentNode = nodeiterator.getRoot();
        while (currentNode != null) {
            this.createObjectFromNode(currentNode);
            currentNode = nodeiterator.nextNode();
        }
    }

    protected MascoptObject createObjectFromNode(Node currentNode) {
        if (currentNode.getNodeName().equalsIgnoreCase("vertex")) {
            return this.createAndAttachVertex(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("edge")) {
            return this.createAndAttachEdge(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("arc")) {
            return this.createAndAttachArc(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("vertex_set")) {
            return this.createAndAttachVertexSet(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("edge_set")) {
            return this.createAndAttachEdgeSet(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("arc_set")) {
            return this.createAndAttachArcSet(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("graph_set")) {
            return this.createAndAttachGraphSet(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("digraph_set")) {
            return this.createAndAttachDiGraphSet(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("path_set")) {
            return this.createAndAttachPathSet(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("dipath_set")) {
            return this.createAndAttachDiPathSet(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("path")) {
            return this.createAndAttachPath(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("dipath")) {
            return this.createAndAttachDiPath(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("graph")) {
            return this.createAndAttachGraph(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("digraph")) {
            return this.createAndAttachDiGraph(currentNode);
        }
        return null;
    }

    protected MascoptObject getObjectByRef(Node currentNode) {
        if (currentNode.getNodeName().equalsIgnoreCase("vertex_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachVertex(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("edge_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachEdge(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("arc_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachArc(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("vertex_set_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachVertexSet(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("edge_set_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachEdgeSet(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("arc_set_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachArcSet(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("graph_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachGraph(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("digraph_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachDiGraph(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("path_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachPath(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("dipath_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachDiPath(this.doc.getElementById(refname));
        }
        return null;
    }

    private String getReferenceName(Node currentNode) {
        String refname = null;
        NamedNodeMap nnm = currentNode.getAttributes();
        NodeList reflist = nnm.getNamedItem("idref").getChildNodes();
        for (int i = 0; refname == null && i < reflist.getLength(); ++i) {
            if (!reflist.item(i).getNodeName().equalsIgnoreCase("#text")) continue;
            refname = reflist.item(i).getNodeValue();
        }
        return refname;
    }

    private Node getElementNodeInSubtree(String element, Node node) {
        if (node == null || element == null) {
            return null;
        }
        Node returnedNode = null;
        if (node.getNodeName().equalsIgnoreCase(element)) {
            returnedNode = node;
        } else {
            NodeList nl = node.getChildNodes();
            for (int i = 0; returnedNode == null && i < nl.getLength(); ++i) {
                returnedNode = this.getElementNodeInSubtree(element, nl.item(i));
            }
        }
        return returnedNode;
    }

    protected Vertex createAndAttachVertex(Node currentNode) {
        Vertex vertex = (Vertex)((NodeImpl)currentNode).getUserData("vertex");
        if (vertex != null) {
            return vertex;
        }
        vertex = new Vertex();
        this.abstractVertexVector.add(vertex);
        ((NodeImpl)currentNode).setUserData("vertex", (Object)vertex, null);
        NodeList nl = currentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(vertex, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("position")) {
                this.setPosition(vertex, nl.item(i));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("value")) continue;
            this.setValue(vertex, nl.item(i));
        }
        return vertex;
    }

    protected Edge createAndAttachEdge(Node currentNode) {
        int i;
        Edge edge = (Edge)((NodeImpl)currentNode).getUserData("edge");
        if (edge != null) {
            return edge;
        }
        Vector<MascoptObject> myvertices = new Vector<MascoptObject>();
        NodeList nl = currentNode.getChildNodes();
        for (i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equalsIgnoreCase("vertex_ref")) continue;
            myvertices.add(this.getObjectByRef(nl.item(i)));
        }
        edge = new Edge((Vertex)myvertices.elementAt(0), (Vertex)myvertices.elementAt(1));
        this.abstractEdgeVector.add(edge);
        ((NodeImpl)currentNode).setUserData("edge", (Object)edge, null);
        for (i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(edge, nl.item(i));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("value")) continue;
            this.setValue(edge, nl.item(i));
        }
        return edge;
    }

    protected Arc createAndAttachArc(Node currentNode) {
        int i;
        Arc arc = (Arc)((NodeImpl)currentNode).getUserData("arc");
        if (arc != null) {
            return arc;
        }
        Vector<MascoptObject> myvertices = new Vector<MascoptObject>();
        NodeList nl = currentNode.getChildNodes();
        for (i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equalsIgnoreCase("vertex_ref")) continue;
            myvertices.add(this.getObjectByRef(nl.item(i)));
        }
        arc = new Arc((Vertex)myvertices.elementAt(0), (Vertex)myvertices.elementAt(1));
        this.abstractEdgeVector.add(arc);
        ((NodeImpl)currentNode).setUserData("arc", (Object)arc, null);
        for (i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(arc, nl.item(i));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("value")) continue;
            this.setValue(arc, nl.item(i));
        }
        return arc;
    }

    protected Graph createAndAttachGraph(Node currentNode) {
        Graph graph = (Graph)((NodeImpl)currentNode).getUserData("graph");
        if (graph != null) {
            return graph;
        }
        graph = new Graph();
        this.abstractGraphVector.add(graph);
        ((NodeImpl)currentNode).setUserData("graph", (Object)graph, null);
        NodeList nl = currentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(graph, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("value")) {
                this.setValue(graph, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("graph_ref")) {
                graph.setSuperGraph((Graph)this.getObjectByRef(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("vertex_set_ref")) {
                graph.setVertexSet((VertexSet)this.getObjectByRef(nl.item(i)));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("edge_set_ref")) continue;
            graph.setEdgeSet((EdgeSet)this.getObjectByRef(nl.item(i)));
        }
        return graph;
    }

    protected DiGraph createAndAttachDiGraph(Node currentNode) {
        DiGraph digraph = (DiGraph)((NodeImpl)currentNode).getUserData("digraph");
        if (digraph != null) {
            return digraph;
        }
        digraph = new DiGraph();
        this.abstractGraphVector.add(digraph);
        ((NodeImpl)currentNode).setUserData("digraph", (Object)digraph, null);
        NodeList nl = currentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(digraph, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("value")) {
                this.setValue(digraph, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("vertex_set_ref")) {
                digraph.setVertexSet((VertexSet)this.getObjectByRef(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("digraph_ref")) {
                digraph.setSuperGraph((DiGraph)this.getObjectByRef(nl.item(i)));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("arc_set_ref")) continue;
            digraph.setArcSet((ArcSet)this.getObjectByRef(nl.item(i)));
        }
        return digraph;
    }

    protected Path createAndAttachPath(Node currentNode) {
        int i;
        Path path = (Path)((NodeImpl)currentNode).getUserData("path");
        if (path != null) {
            return path;
        }
        NodeList nl = currentNode.getChildNodes();
        for (i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equalsIgnoreCase("edge_set_ref")) continue;
            path = new Path((EdgeSet)this.getObjectByRef(nl.item(i)));
        }
        this.abstractPathVector.add(path);
        ((NodeImpl)currentNode).setUserData("path", (Object)path, null);
        for (i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(path, nl.item(i));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("value")) continue;
            this.setValue(path, nl.item(i));
        }
        return path;
    }

    protected DiPath createAndAttachDiPath(Node currentNode) {
        int i;
        DiPath dipath = (DiPath)((NodeImpl)currentNode).getUserData("dipath");
        if (dipath != null) {
            return dipath;
        }
        NodeList nl = currentNode.getChildNodes();
        for (i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equalsIgnoreCase("arc_set_ref")) continue;
            dipath = new DiPath((ArcSet)this.getObjectByRef(nl.item(i)));
        }
        this.abstractPathVector.add(dipath);
        ((NodeImpl)currentNode).setUserData("dipath", (Object)dipath, null);
        for (i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(dipath, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("value")) {
                this.setValue(dipath, nl.item(i));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("arc_ref")) continue;
            dipath.concat((Arc)this.getObjectByRef(nl.item(i)));
        }
        return dipath;
    }

    protected void setName(MascoptObject object, Node name) {
        object.setName(this.getElementNodeInSubtree("#text", name).getNodeValue().trim());
    }

    protected void setPosition(MascoptObject object, Node position) {
        NodeList nl = position.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("x")) {
                ((Vertex)object).setX(Double.parseDouble(this.getElementNodeInSubtree("#text", nl.item(i)).getNodeValue()));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("y")) continue;
            ((Vertex)object).setY(Double.parseDouble(this.getElementNodeInSubtree("#text", nl.item(i)).getNodeValue()));
        }
    }

    protected void setValue(MascoptObject object, Node value) {
        String valueQuantity = null;
        MascoptObject context = null;
        NodeList list = value.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!list.item(i).getNodeName().equalsIgnoreCase("#text")) continue;
            valueQuantity = list.item(i).getNodeValue().trim();
        }
        NamedNodeMap nnm = value.getAttributes();
        String valueName = this.getElementNodeInSubtree("#text", nnm.getNamedItem("type")).getNodeValue();
        String valueDataType = this.getElementNodeInSubtree("#text", nnm.getNamedItem("dataType")).getNodeValue();
        Node contextRefNode = this.getElementNodeInSubtree("#text", nnm.getNamedItem("context"));
        if (contextRefNode != null) {
            String contextValue = contextRefNode.getNodeValue();
            Element contextNode = this.doc.getElementById(contextValue);
            context = this.createObjectFromNode(contextNode);
        }
        if (valueDataType.equalsIgnoreCase("integer")) {
            Integer valueQuantityI = Integer.valueOf(valueQuantity);
            if (context == null) {
                object.setValue(valueName, valueQuantityI);
            } else {
                object.setValue(valueName, (MascoptObjectInterface)context, valueQuantityI);
            }
        } else if (valueDataType.equalsIgnoreCase("double")) {
            Double valueQuantityD = Double.valueOf(valueQuantity);
            if (context == null) {
                object.setValue(valueName, valueQuantityD);
            } else {
                object.setValue(valueName, (MascoptObjectInterface)context, valueQuantityD);
            }
        } else if (context == null) {
            object.setValue(valueName, valueQuantity);
        } else {
            object.setValue(valueName, (MascoptObjectInterface)context, valueQuantity);
        }
    }

    protected VertexSet createAndAttachVertexSet(Node currentNode) {
        VertexSet vertexset = (VertexSet)((NodeImpl)currentNode).getUserData("vertexset");
        if (vertexset != null) {
            return vertexset;
        }
        vertexset = new VertexSet();
        this.abstractVertexSetVector.add(vertexset);
        ((NodeImpl)currentNode).setUserData("vertexset", (Object)vertexset, null);
        NodeList nl = currentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(vertexset, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("value")) {
                this.setValue(vertexset, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("vertex_ref")) {
                vertexset.add((Vertex)this.getObjectByRef(nl.item(i)));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("vertex_set_ref")) continue;
            vertexset.setSuperSet((MascoptSet)this.getObjectByRef(nl.item(i)));
        }
        return vertexset;
    }

    protected EdgeSet createAndAttachEdgeSet(Node currentNode) {
        int i;
        EdgeSet edgeset = (EdgeSet)((NodeImpl)currentNode).getUserData("edgeset");
        if (edgeset != null) {
            return edgeset;
        }
        NodeList nl = currentNode.getChildNodes();
        for (i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equalsIgnoreCase("vertex_set_ref")) continue;
            edgeset = new EdgeSet((VertexSet)this.getObjectByRef(nl.item(i)));
        }
        if (edgeset == null) {
            edgeset = this.oldTypeEdgeSet(nl);
        }
        this.abstractEdgeSetVector.add(edgeset);
        ((NodeImpl)currentNode).setUserData("edgeset", (Object)edgeset, null);
        for (i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(edgeset, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("value")) {
                this.setValue(edgeset, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("edge_ref")) {
                edgeset.add((Edge)this.getObjectByRef(nl.item(i)));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("edge_set_ref")) continue;
            edgeset.setSuperSet((EdgeSet)this.getObjectByRef(nl.item(i)));
        }
        return edgeset;
    }

    protected ArcSet createAndAttachArcSet(Node currentNode) {
        int i;
        ArcSet arcset = (ArcSet)((NodeImpl)currentNode).getUserData("arcset");
        if (arcset != null) {
            return arcset;
        }
        NodeList nl = currentNode.getChildNodes();
        for (i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equalsIgnoreCase("vertex_set_ref")) continue;
            arcset = new ArcSet((VertexSet)this.getObjectByRef(nl.item(i)));
        }
        if (arcset == null) {
            arcset = this.oldTypeArcSet(nl);
        }
        this.abstractEdgeSetVector.add(arcset);
        ((NodeImpl)currentNode).setUserData("arcset", (Object)arcset, null);
        for (i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(arcset, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("value")) {
                this.setValue(arcset, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("arc_ref")) {
                arcset.add((Arc)this.getObjectByRef(nl.item(i)));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("arc_set_ref")) continue;
            arcset.setSuperSet((ArcSet)this.getObjectByRef(nl.item(i)));
        }
        return arcset;
    }

    protected GraphSet createAndAttachGraphSet(Node currentNode) {
        GraphSet graphset = (GraphSet)((NodeImpl)currentNode).getUserData("graphset");
        if (graphset != null) {
            return graphset;
        }
        graphset = new GraphSet();
        this.abstractGraphSetVector.add(graphset);
        ((NodeImpl)currentNode).setUserData("graphset", (Object)graphset, null);
        NodeList nl = currentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(graphset, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("value")) {
                this.setValue(graphset, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("graph_ref")) {
                graphset.add((Graph)this.getObjectByRef(nl.item(i)));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("graph_set_ref")) continue;
            graphset.setSuperSet((GraphSet)this.getObjectByRef(nl.item(i)));
        }
        return graphset;
    }

    protected DiGraphSet createAndAttachDiGraphSet(Node currentNode) {
        DiGraphSet digraphset = (DiGraphSet)((NodeImpl)currentNode).getUserData("digraphset");
        if (digraphset != null) {
            return digraphset;
        }
        digraphset = new DiGraphSet();
        this.abstractGraphSetVector.add(digraphset);
        ((NodeImpl)currentNode).setUserData("digraphset", (Object)digraphset, null);
        NodeList nl = currentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(digraphset, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("value")) {
                this.setValue(digraphset, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("digraph_ref")) {
                digraphset.add((DiGraph)this.getObjectByRef(nl.item(i)));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("digraph_set_ref")) continue;
            digraphset.setSuperSet((DiGraphSet)this.getObjectByRef(nl.item(i)));
        }
        return digraphset;
    }

    protected PathSet createAndAttachPathSet(Node currentNode) {
        PathSet pathset = (PathSet)((NodeImpl)currentNode).getUserData("pathset");
        if (pathset != null) {
            return pathset;
        }
        pathset = new PathSet();
        this.abstractPathSetVector.add(pathset);
        ((NodeImpl)currentNode).setUserData("pathset", (Object)pathset, null);
        NodeList nl = currentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(pathset, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("value")) {
                this.setValue(pathset, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("path_ref")) {
                pathset.add((Path)this.getObjectByRef(nl.item(i)));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("path_set_ref")) continue;
            pathset.setSuperSet((PathSet)this.getObjectByRef(nl.item(i)));
        }
        return pathset;
    }

    protected DiPathSet createAndAttachDiPathSet(Node currentNode) {
        DiPathSet dipathset = (DiPathSet)((NodeImpl)currentNode).getUserData("dipathset");
        if (dipathset != null) {
            return dipathset;
        }
        dipathset = new DiPathSet();
        this.abstractPathSetVector.add(dipathset);
        ((NodeImpl)currentNode).setUserData("dipathset", (Object)dipathset, null);
        NodeList nl = currentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(dipathset, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("value")) {
                this.setValue(dipathset, nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("dipath_ref")) {
                dipathset.add((DiPath)this.getObjectByRef(nl.item(i)));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("dipath_set_ref")) continue;
            dipathset.setSuperSet((DiPathSet)this.getObjectByRef(nl.item(i)));
        }
        return dipathset;
    }

    private EdgeSet oldTypeEdgeSet(NodeList nl) {
        VertexSet altVertexSet = new VertexSet();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equalsIgnoreCase("edge_ref")) continue;
            Edge edge = (Edge)this.getObjectByRef(nl.item(i));
            altVertexSet.add(edge.getVertices()[0]);
            altVertexSet.add(edge.getVertices()[1]);
        }
        return new EdgeSet(altVertexSet);
    }

    private ArcSet oldTypeArcSet(NodeList nl) {
        VertexSet altVertexSet = new VertexSet();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equalsIgnoreCase("arc_ref")) continue;
            Arc arc = (Arc)this.getObjectByRef(nl.item(i));
            altVertexSet.add((Vertex)arc.getHead());
            altVertexSet.add((Vertex)arc.getTail());
        }
        return new ArcSet(altVertexSet);
    }

    public int getNumberOfGraphs() {
        return this.abstractGraphVector.size();
    }

    public void setValidating(boolean validation) {
        this.validate = validation;
    }

    class mySax2XMLReaderCreator
    extends Sax2XMLReaderCreator {
        private SAXParser parser_ = null;

        public mySax2XMLReaderCreator() {
            try {
                this.parser_ = new SAXParser();
                this.parser_.setFeature("http://xml.org/sax/features/validation", false);
                this.parser_.setEntityResolver((EntityResolver)new MGLEntityResolver());
            }
            catch (DOMException e) {
                System.out.println("Error while creating parser: " + e);
            }
            catch (SAXNotRecognizedException e) {
                System.out.println("Error while creating parser: " + e);
            }
            catch (SAXNotSupportedException e) {
                System.out.println("Error while creating parser: " + e);
            }
        }

        public XMLReader createXMLReader() {
            return this.parser_;
        }
    }
}

