/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.graph;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import mascoptLib.abstractGraph.MascoptObject;
import mascoptLib.io.WriterInterface;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class MGLWriter
implements WriterInterface {
    private Document document;
    protected OutputStream os;
    public static String rootElementForXMLFile = "OBJECTS";
    public String SYSTEM = "SYSTEM";
    public static String DTD = "ftp://ftp-sop.inria.fr/mascotte/mascopt/dtd/mgl_v1.4.dtd";
    public static String relaxNG = "ftp://ftp-sop.inria.fr/mascotte/mascopt/dtd/mgl_v1.4.rng";
    public static String relaxNGVersionAttribute = "version";
    private DOMImplementationImpl xerces_impl;

    public MGLWriter(String file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public MGLWriter(OutputStream os) {
        this.os = os;
        DOMImplementation dom_impl = DOMImplementationImpl.getDOMImplementation();
        DocumentType docType = dom_impl.createDocumentType(rootElementForXMLFile, this.SYSTEM, DTD);
        this.document = dom_impl.createDocument(null, rootElementForXMLFile, docType);
        Element node = (Element)this.document.getElementsByTagName(rootElementForXMLFile).item(0);
        node.setAttribute(relaxNGVersionAttribute, relaxNG);
    }

    public void add(MascoptObject object) {
        Element produced_node = object.toDOMTree(this.document.getDocumentElement());
    }

    public void write() {
        OutputFormat format = new OutputFormat(this.document);
        format.setLineWidth(80);
        format.setIndenting(true);
        format.setIndent(2);
        format.setEncoding("ISO-8859-1");
        XMLSerializer serializer = new XMLSerializer(this.os, format);
        try {
            serializer.serialize(this.document);
        }
        catch (IOException e) {
            System.out.println("Error when serializing into the file." + e);
        }
    }
}

