/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.graph;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractEdgeSet;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractPath;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.AbstractVertexSet;
import mascoptLib.abstractGraph.MascoptObject;
import mascoptLib.abstractGraph.MascoptObjectInterface;
import mascoptLib.abstractGraph.MascoptSet;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.ArcSet;
import mascoptLib.graphs.DiGraph;
import mascoptLib.graphs.DiPath;
import mascoptLib.graphs.Edge;
import mascoptLib.graphs.EdgeSet;
import mascoptLib.graphs.Graph;
import mascoptLib.graphs.Path;
import mascoptLib.io.WriterInterface;
import mascoptLib.util.Trace;

public class MGLWriter_1_2
implements WriterInterface {
    protected HashMap abstractNodeTable = new HashMap();
    protected HashMap abstractEdgeTable = new HashMap();
    protected HashMap abstractNodeSetTable = new HashMap();
    protected HashMap abstractEdgeSetTable = new HashMap();
    protected HashMap abstractGraphTable;
    protected HashMap abstractChainTable = new HashMap();
    protected OutputStream os;
    protected Iterator iterator;
    protected PrintStream ps;
    protected String HEADER = "<?xml version=\"1.0\" ?>\n<!DOCTYPE OBJECTS SYSTEM \"ftp://ftp-sop.inria.fr/mascotte/mascopt/dtd/mgl_v1.2.dtd\">";

    public MGLWriter_1_2(String file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public MGLWriter_1_2(OutputStream os) {
        this.abstractGraphTable = new HashMap();
        this.os = os;
        this.os = os;
    }

    public void add(MascoptObject object) {
        if (object instanceof AbstractVertex) {
            this.addAbstractNode((AbstractVertex)object);
        } else if (object instanceof AbstractEdge) {
            this.addAbstractEdge((AbstractEdge)object);
        } else if (object instanceof AbstractVertexSet) {
            this.addAbstractNodeSet((AbstractVertexSet)object);
        } else if (object instanceof AbstractEdgeSet) {
            this.addAbstractEdgeSet((AbstractEdgeSet)object);
        } else if (object instanceof AbstractPath) {
            this.addAbstractChain((AbstractPath)object);
        } else if (object instanceof AbstractGraph) {
            this.addAbstractGraph((AbstractGraph)object);
        }
    }

    private void addAbstractNode(AbstractVertex node) {
        this.abstractNodeTable.put(node.getId(), node);
    }

    private void addAbstractEdge(AbstractEdge abstractEdge) {
        this.abstractEdgeTable.put(abstractEdge.getId(), abstractEdge);
        AbstractVertex[] abstractNode = abstractEdge.getAbstractVertices();
        this.add(abstractNode[0]);
        this.add(abstractNode[1]);
    }

    private void addAbstractNodeSet(AbstractVertexSet abstractNodeSet) {
        if (abstractNodeSet.isSubSet()) {
            this.add(abstractNodeSet.getSuperSet());
        }
        this.abstractNodeSetTable.put(abstractNodeSet.getId(), abstractNodeSet);
        Iterator abstractNodes = abstractNodeSet.iterator();
        while (abstractNodes.hasNext()) {
            this.add((AbstractVertex)abstractNodes.next());
        }
    }

    private void addAbstractEdgeSet(AbstractEdgeSet abstractEdgeSet) {
        AbstractVertexSet nodeSet;
        if (abstractEdgeSet.isSubSet()) {
            this.add(abstractEdgeSet.getSuperSet());
        }
        if ((nodeSet = abstractEdgeSet.getAbstractVertexSet()) != null) {
            this.add(nodeSet);
        }
        this.abstractEdgeSetTable.put(abstractEdgeSet.getId(), abstractEdgeSet);
        Iterator abstractEdges = abstractEdgeSet.iterator();
        while (abstractEdges.hasNext()) {
            this.add((AbstractEdge)abstractEdges.next());
        }
    }

    private void addAbstractChain(AbstractPath abstractChain) {
        if (abstractChain.isSubGraph()) {
            this.add(abstractChain.getSuperGraph());
        }
        this.abstractChainTable.put(abstractChain.getId(), abstractChain);
    }

    private void addAbstractGraph(AbstractGraph abstractGraph) {
        if (abstractGraph.isSubGraph()) {
            this.add(abstractGraph.getSuperGraph());
        }
        this.abstractGraphTable.put(abstractGraph.getId(), abstractGraph);
        this.add(abstractGraph.getAbstractVertexSet());
        this.add(abstractGraph.getAbstractEdgeSet());
    }

    public void write() {
        this.ps = new PrintStream(this.os);
        this.writeStart();
        this.writeNodes();
        this.writeEdges();
        this.writeArcs();
        this.writeNodeSet();
        this.writeEdgeSet();
        this.writeArcSet();
        this.writeChain();
        this.writeGraph();
        this.writeEnd();
    }

    protected void writeStart() {
        this.ps.println(this.HEADER);
        this.ps.println("\n\n");
        this.ps.println("<OBJECTS>");
        this.ps.println();
    }

    protected void writeNodes() {
        this.ps.println();
        this.ps.println("<!-- Nodes -->");
        this.ps.println();
        this.ps.println("<VERTICES>");
        this.iterator = this.abstractNodeTable.values().iterator();
        while (this.iterator.hasNext()) {
            AbstractVertex abstractNode = (AbstractVertex)this.iterator.next();
            this.ps.println("<VERTEX id=\"" + abstractNode.getId() + "\">");
            this.writeName(abstractNode, this.ps);
            this.ps.println("\t<POSITION>");
            this.ps.println("\t\t<X>" + abstractNode.getX() + "</X>");
            this.ps.println("\t\t<Y>" + abstractNode.getY() + "</Y>");
            this.ps.println("\t</POSITION>");
            this.writeValues(abstractNode, this.ps);
            this.ps.println("</VERTEX>");
        }
        this.ps.println("</VERTICES>");
    }

    protected void writeEdges() {
        this.ps.println();
        this.ps.println("<!-- Edges -->");
        this.ps.println();
        this.ps.println("<LINKS>");
        this.iterator = this.abstractEdgeTable.values().iterator();
        while (this.iterator.hasNext()) {
            Object object = this.iterator.next();
            if (!(object instanceof Edge)) continue;
            Edge edge = (Edge)object;
            AbstractVertex[] abstractNodes = edge.getAbstractVertices();
            this.ps.println("<EDGE id=\"" + edge.getId() + "\">");
            this.writeName(edge, this.ps);
            this.ps.println("\t<VERTEX_REF idref=\"" + abstractNodes[0] + "\"/>");
            this.ps.println("\t<VERTEX_REF idref=\"" + abstractNodes[1] + "\"/>");
            this.writeValues(edge, this.ps);
            this.ps.println("</EDGE>");
        }
    }

    protected void writeArcs() {
        this.ps.println();
        this.ps.println("<!-- Arcs -->");
        this.ps.println();
        this.iterator = this.abstractEdgeTable.values().iterator();
        while (this.iterator.hasNext()) {
            Object object = this.iterator.next();
            if (!(object instanceof Arc)) continue;
            Arc arc = (Arc)object;
            this.ps.println("<ARC id=\"" + arc.getId() + "\">");
            this.writeName(arc, this.ps);
            this.ps.println("\t<VERTEX_REF idref=\"" + arc.getTail() + "\"/>");
            this.ps.println("\t<VERTEX_REF idref=\"" + arc.getHead() + "\"/>");
            this.writeValues(arc, this.ps);
            this.ps.println("</ARC>");
        }
        this.ps.println("</LINKS>");
    }

    protected void writeNodeSet() {
        this.ps.println();
        this.ps.println("<!-- NodeSet -->");
        this.ps.println();
        this.ps.println("<SETS>");
        this.iterator = this.abstractNodeSetTable.values().iterator();
        while (this.iterator.hasNext()) {
            AbstractVertexSet abstractNodeSet = (AbstractVertexSet)this.iterator.next();
            this.ps.println("<VERTEX_SET id=\"" + abstractNodeSet.getId() + "\">");
            this.writeName(abstractNodeSet, this.ps);
            this.writeSuperSet(abstractNodeSet, this.ps);
            this.writeElements(abstractNodeSet, this.ps, "VERTEX_REF");
            this.writeValues(abstractNodeSet, this.ps);
            this.ps.println("</VERTEX_SET>");
        }
    }

    protected void writeEdgeSet() {
        this.ps.println();
        this.ps.println("<!-- EdgeSet -->");
        this.ps.println();
        this.iterator = this.abstractEdgeSetTable.values().iterator();
        while (this.iterator.hasNext()) {
            AbstractEdgeSet abstractEdgeSet = (AbstractEdgeSet)this.iterator.next();
            String type = "?";
            if (!(abstractEdgeSet instanceof EdgeSet)) continue;
            type = "EDGE";
            this.ps.println("<" + type + "_SET id=\"" + abstractEdgeSet.getId() + "\">");
            this.writeName(abstractEdgeSet, this.ps);
            this.writeSuperSet(abstractEdgeSet, this.ps);
            AbstractVertexSet nodeSet = abstractEdgeSet.getAbstractVertexSet();
            if (nodeSet != null) {
                this.ps.println("\t<VERTEX_SET_REF idref=\"" + nodeSet.getId() + "\"/>");
            }
            this.writeElements(abstractEdgeSet, this.ps, type + "_REF");
            this.writeValues(abstractEdgeSet, this.ps);
            this.ps.println("</" + type + "_SET>");
        }
    }

    protected void writeArcSet() {
        this.ps.println();
        this.ps.println("<!--  ArcSet -->");
        this.ps.println();
        this.iterator = this.abstractEdgeSetTable.values().iterator();
        while (this.iterator.hasNext()) {
            AbstractEdgeSet abstractEdgeSet = (AbstractEdgeSet)this.iterator.next();
            String type = "?";
            if (!(abstractEdgeSet instanceof ArcSet)) continue;
            type = "ARC";
            this.ps.println("<" + type + "_SET id=\"" + abstractEdgeSet.getId() + "\">");
            this.writeName(abstractEdgeSet, this.ps);
            this.writeSuperSet(abstractEdgeSet, this.ps);
            AbstractVertexSet nodeSet = abstractEdgeSet.getAbstractVertexSet();
            if (nodeSet != null) {
                this.ps.println("\t<VERTEX_SET_REF idref=\"" + nodeSet.getId() + "\"/>");
            }
            this.writeElements(abstractEdgeSet, this.ps, type + "_REF");
            this.writeValues(abstractEdgeSet, this.ps);
            this.ps.println("</" + type + "_SET>");
        }
        this.ps.println("</SETS>");
    }

    protected void writeChain() {
        this.ps.println();
        this.ps.println("<!-- Chain/ Path -->");
        this.ps.println();
        this.iterator = this.abstractChainTable.values().iterator();
        if (this.iterator.hasNext()) {
            this.ps.println("<PATHS>");
            while (this.iterator.hasNext()) {
                AbstractPath abstractChain = (AbstractPath)this.iterator.next();
                if (abstractChain.isMulti()) {
                    Trace.printErrln("MGXWriter: multichain write not implemented  ");
                    continue;
                }
                String type = "?";
                String tagName = "?";
                if (abstractChain instanceof Path) {
                    type = "EDGE";
                    tagName = "CHAIN";
                } else if (abstractChain instanceof DiPath) {
                    type = "ARC";
                    tagName = "PATH";
                }
                this.ps.println("<" + tagName + " id=\"" + abstractChain.getId() + "\">");
                this.writeName(abstractChain, this.ps);
                this.ps.println("\t<" + type + "_SET_REF idref=\"" + abstractChain.getSuperGraph().getId() + "\"/>");
                AbstractVertex start = abstractChain.getAbstractStart();
                AbstractVertex tmp = abstractChain.getAbstractStart();
                while (tmp != abstractChain.getAbstractEnd()) {
                    this.ps.println("\t<" + type + "_REF idref=\"" + abstractChain.nextAbstractEdge(tmp).getId() + "\"/>");
                    tmp = abstractChain.nextAbstractVertex(tmp);
                }
                this.writeValues(abstractChain, this.ps);
                this.ps.println("</" + tagName + ">");
            }
            this.ps.println("</PATHS>");
        }
    }

    protected void writeGraph() {
        this.ps.println();
        this.ps.println("<!-- Graph / DiGraph -->");
        this.ps.println();
        this.ps.println("<GRAPHS>");
        this.iterator = this.abstractGraphTable.values().iterator();
        while (this.iterator.hasNext()) {
            AbstractGraph abstractGraph = (AbstractGraph)this.iterator.next();
            if (abstractGraph instanceof Graph) {
                Graph graph = (Graph)abstractGraph;
                this.ps.println("<GRAPH id=\"" + graph.getId() + "\">");
                this.writeName(graph, this.ps);
                this.writeSuperGraph(graph, this.ps);
                this.ps.println("\t<VERTEX_SET_REF idref=\"" + graph.getVertexSet().getId() + "\"/>");
                this.ps.println("\t<EDGE_SET_REF idref=\"" + graph.getEdgeSet().getId() + "\"/>");
                this.writeValues(graph, this.ps);
                this.ps.println("</GRAPH>");
                continue;
            }
            if (!(abstractGraph instanceof DiGraph)) continue;
            DiGraph digraph = (DiGraph)abstractGraph;
            this.ps.println("<DIGRAPH id=\"" + digraph.getId() + "\">");
            this.writeName(digraph, this.ps);
            this.writeSuperGraph(digraph, this.ps);
            this.ps.println("\t<VERTEX_SET_REF idref=\"" + digraph.getVertexSet().getId() + "\"/>");
            this.ps.println("\t<ARC_SET_REF idref=\"" + digraph.getArcSet().getId() + "\"/>");
            this.writeValues(digraph, this.ps);
            this.ps.println("</DIGRAPH>");
        }
        this.ps.println("</GRAPHS>");
        this.ps.println();
    }

    protected void writeEnd() {
        this.ps.println();
        this.ps.println("</OBJECTS>");
    }

    protected void writeName(MascoptObjectInterface object, PrintStream ps) {
        String name = object.getName();
        if (name != null) {
            ps.println("\t<NAME> " + name + " </NAME>");
        }
    }

    protected void writeValues(MascoptObjectInterface object, PrintStream ps) {
        Iterator it = object.getValueEntries();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            String entry = (String)it.next();
            if (entry.equals("id") || entry.equals("x") || entry.equals("y")) continue;
            String dataType = object.getValueDataType(entry);
            ps.println("\t<VALUE type=\"" + entry + "\" dataType=\"" + dataType + "\"> " + object.getValue(entry) + " </VALUE>");
        }
    }

    protected MascoptObjectInterface findObject(String id) {
        MascoptObjectInterface moi = null;
        moi = (MascoptObjectInterface)this.abstractNodeTable.get(id);
        if (moi != null) {
            return moi;
        }
        moi = (MascoptObjectInterface)this.abstractEdgeTable.get(id);
        if (moi != null) {
            return moi;
        }
        moi = (MascoptObjectInterface)this.abstractNodeSetTable.get(id);
        if (moi != null) {
            return moi;
        }
        moi = (MascoptObjectInterface)this.abstractEdgeSetTable.get(id);
        if (moi != null) {
            return moi;
        }
        moi = (MascoptObjectInterface)this.abstractGraphTable.get(id);
        if (moi != null) {
            return moi;
        }
        moi = (MascoptObjectInterface)this.abstractChainTable.get(id);
        if (moi != null) {
            return moi;
        }
        return moi;
    }

    protected void writeSuperSet(MascoptSet ms, PrintStream ps) {
        if (ms.isSubSet() && this.findObject(ms.getSuperSet().getId()) != null) {
            ps.println("\t<SUPER_SET_REF idref=\"" + ms.getSuperSet().getId() + "\"/>");
        }
    }

    protected void writeSuperGraph(AbstractGraph ag, PrintStream ps) {
        if (ag.isSubGraph() && this.findObject(ag.getSuperGraph().getId()) != null) {
            ps.println("\t<SUPER_GRAPH_REF idref=\"" + ag.getSuperGraph().getId() + "\"/>");
        }
    }

    protected void writeElements(MascoptSet ms, PrintStream ps, String tagName) {
        Iterator elements = ms.iterator();
        while (elements.hasNext()) {
            ps.println("\t<" + tagName + " idref=\"" + ((MascoptObject)elements.next()).getId() + "\"/>");
        }
    }
}

