/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.graph;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.MascoptObject;
import mascoptLib.io.WriterInterface;

public class MPWriter
implements WriterInterface {
    protected OutputStream os;
    protected AbstractGraph g_;
    public double s = 1.0;
    public double circle_size = 16.0;

    public MPWriter(String file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public MPWriter(OutputStream os) {
        this.os = os;
    }

    public void add(MascoptObject object) {
        if (object instanceof AbstractGraph) {
            this.g_ = (AbstractGraph)object;
        }
    }

    public void write() {
        PrintStream stream = new PrintStream(this.os);
        stream.println("% +MP-ADDITIONAL-HEADER");
        stream.println("verbatimtex");
        stream.println("%&latex");
        stream.println("\\documentclass{article}");
        stream.println("\\begin{document}");
        stream.println("etex");
        stream.println("% -MP-ADDITIONAL-HEADER");
        stream.println("%SetFigFont macros for latex");
        stream.println("verbatimtex");
        stream.println("%");
        stream.println("\\begingroup\\makeatletter\\ifx\\SetFigFont\\undefined%");
        stream.println("\\gdef\\SetFigFont#1#2#3#4#5{%");
        stream.println("  \\reset@font\\fontsize{#1}{#2pt}%");
        stream.println("  \\fontfamily{#3}\\fontseries{#4}\\fontshape{#5}%");
        stream.println("  \\selectfont}%");
        stream.println("\\fi\\endgroup%");
        stream.println("\\ifx\\SetFigFontSize\\undefined%");
        stream.println("\\gdef\\SetFigFontSize#1#2{%");
        stream.println("  \\fontsize{#1}{#2pt}%");
        stream.println("  \\selectfont}%");
        stream.println("\\fi%");
        stream.println("etex");
        stream.println("% NOTE: subject to change (edited from plain.mp)");
        stream.println("    def forwarr(text t) expr p =");
        stream.println("      _apth:=p;_finarrf(t)");
        stream.println("    enddef;");
        stream.println("    def backarr(text t) expr p =");
        stream.println("      _apth:=p;_finarrb(t)");
        stream.println("    enddef;");
        stream.println("    def _finarrf(text s) text t =");
        stream.println("      if (s=0):fill arrowhead _apth  t withcolor white");
        stream.println("      else: fill arrowhead _apth  t fi;");
        stream.println("      linejoin:=0;");
        stream.println("      draw arrowhead _apth  t");
        stream.println("    enddef;");
        stream.println("    def _finarrb(text s) text t =");
        stream.println("      if (s=0):fill arrowhead reverse _apth  t withcolor white");
        stream.println("      else: fill arrowhead reverse _apth  t fi;");
        stream.println("      linejoin:=0;");
        stream.println("      draw arrowhead reverse _apth  t");
        stream.println("    enddef;");
        stream.println("% Now draw the figure");
        stream.println("beginfig(0)");
        stream.println("% Some reasonable defaults");
        stream.println("  ahlength:=7;");
        stream.println("  ahangle:=30;");
        stream.println("  labeloffset:=0;");
        stream.println("  truecorners:=1;");
        stream.println("  bboxmargin:=0;");
        Iterator it_node = this.g_.getAbstractVertexSet().iterator();
        double min_x = 1000000.0;
        double max_x = -1000000.0;
        double min_y = 1000000.0;
        double max_y = -1000000.0;
        while (it_node.hasNext()) {
            AbstractVertex v = (AbstractVertex)it_node.next();
            if (v.getX() < min_x) {
                min_x = v.getX();
            }
            if (v.getY() < min_y) {
                min_y = v.getY();
            }
            if (v.getX() > max_x) {
                max_x = v.getX();
            }
            if (!(v.getY() > max_y)) continue;
            max_y = v.getY();
        }
        double delta_x = max_x - min_x;
        double delta_y = max_y - min_y;
        it_node = this.g_.getAbstractVertexSet().iterator();
        while (it_node.hasNext()) {
            AbstractVertex v = (AbstractVertex)it_node.next();
            stream.println("% Begin ellipse object");
            stream.println("  pickup pencircle scaled 0.90;");
            stream.println("  path c;");
            stream.println("  c = fullcircle scaled " + this.circle_size + " yscaled 1.00");
            stream.println("         rotated 0.00 shifted (" + (v.getX() - min_x) * this.s + "," + (delta_y - (v.getY() - min_y)) * this.s + ");");
            stream.println("  fill c withcolor (black + 0.00white);");
            stream.println("  draw c withcolor (0.00,0.00,0.00);");
            stream.println("% End ellipse object");
        }
        Iterator it_edge = this.g_.getAbstractEdgeSet().iterator();
        while (it_edge.hasNext()) {
            AbstractEdge e = (AbstractEdge)it_edge.next();
            AbstractVertex v1 = e.getAbstractVertices()[0];
            AbstractVertex v2 = e.getAbstractVertices()[1];
            stream.println("% Begin polyline object");
            stream.println("  linecap:=0;");
            stream.println("  linejoin:=0;");
            stream.println("  pickup pencircle scaled 0.90;");
            stream.println("  path p;");
            stream.println("  p = (" + (v1.getX() - min_x) * this.s + "," + (delta_y - (v1.getY() - min_y)) * this.s + ")");
            stream.println("    --(" + (v2.getX() - min_x) * this.s + "," + (delta_y - (v2.getY() - min_y)) * this.s + ");");
            stream.println("  draw p withcolor (0.00,0.00,0.00);");
            stream.println("% End polyline object");
        }
        stream.println("endfig;");
        stream.println("end");
    }
}

