/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.graph;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.ArcSet;
import mascoptLib.graphs.DiGraph;
import mascoptLib.graphs.Vertex;
import mascoptLib.graphs.VertexSet;
import mascoptLib.io.ReaderInterface;
import mascoptLib.util.Trace;

public class NetReader
implements ReaderInterface {
    private Vector abstractNodes;
    private Vector abstractEdges;
    private Vector abstractNodeSets;
    private Vector abstractEdgeSets;
    private Vector abstractChains;
    private Vector abstractGraphs;
    private int NO_LIGNE = 0;
    private BufferedReader reader;
    private VertexSet nodeSet;
    protected ArcSet cables;
    private ArcSet demands;
    private boolean mirrorArc;
    private boolean mirrorRequest;

    public NetReader(String fileIn) {
        this(fileIn, false, false);
    }

    public NetReader(String fileIn, boolean mirrorArc, boolean mirrorRequest) {
        Trace.println("new reader");
        this.mirrorArc = mirrorArc;
        this.mirrorRequest = mirrorRequest;
        this.abstractNodes = new Vector();
        this.abstractEdges = new Vector();
        this.abstractNodeSets = new Vector();
        this.abstractEdgeSets = new Vector();
        this.abstractChains = new Vector();
        this.abstractGraphs = new Vector();
        try {
            this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileIn)));
        }
        catch (Exception e) {
            System.out.println("Error opening file " + fileIn);
            return;
        }
        this.nodeSet = new VertexSet();
        this.abstractNodeSets.add(this.nodeSet);
        this.cables = new ArcSet(this.nodeSet);
        this.demands = new ArcSet(this.nodeSet);
        this.abstractEdgeSets.add(this.cables);
        this.abstractEdgeSets.add(this.demands);
        DiGraph cableG = new DiGraph(this.nodeSet, this.cables);
        cableG.setName("graph Cable");
        this.abstractGraphs.add(cableG);
        DiGraph requestG = new DiGraph(this.nodeSet, this.demands);
        requestG.setName("graph Request");
        this.abstractGraphs.add(requestG);
        this.read();
    }

    private void read() {
        String line;
        String capa;
        StringTokenizer st = new StringTokenizer(this.getLine(), " \t");
        String read = st.nextToken();
        int nbLevel = Integer.parseInt(read);
        for (int i = 0; i < nbLevel; ++i) {
            this.getLine();
        }
        st = new StringTokenizer(this.getLine(), " \t");
        read = st.nextToken();
        int nbNodes = Integer.parseInt(read);
        for (int i = 0; i < nbNodes; ++i) {
            st = new StringTokenizer(this.getLine(), " \t");
            String cityName = st.nextToken();
            String cityX = st.nextToken();
            String cityY = st.nextToken();
            Vertex n = new Vertex(Integer.parseInt(cityX), Integer.parseInt(cityY));
            n.setName(cityName);
            n.setValue("NetID", Integer.toString(i));
            this.nodeSet.add(n);
            this.abstractNodes.add(n);
        }
        st = new StringTokenizer(this.getLine(), " \t");
        read = st.nextToken();
        int nbCables = Integer.parseInt(read);
        for (int i = 0; i < nbCables; ++i) {
            st = new StringTokenizer(this.getLine(), " \t");
            int nodeFrom = Integer.parseInt(st.nextToken());
            int nodeTo = Integer.parseInt(st.nextToken());
            capa = st.nextToken();
            String longueur = st.nextToken();
            Vertex from = (Vertex)this.abstractNodes.elementAt(nodeFrom);
            Vertex to = (Vertex)this.abstractNodes.elementAt(nodeTo);
            Arc a = new Arc(from, to);
            a.setValue("Capacity", capa);
            a.setValue("Length", longueur);
            this.cables.add(a);
            this.abstractEdges.add(a);
            if (!this.mirrorArc) continue;
            Arc aReverse = new Arc(to, from);
            aReverse.setValue("Capacity", capa);
            aReverse.setValue("Length", longueur);
            this.cables.add(aReverse);
            this.abstractEdges.add(aReverse);
        }
        while ((line = this.getLine()) != null) {
            if (line.trim().length() == 0) continue;
            st = new StringTokenizer(line, " \t");
            int nodeFrom = Integer.parseInt(st.nextToken());
            int nodeTo = Integer.parseInt(st.nextToken());
            capa = st.nextToken();
            Vertex from = (Vertex)this.abstractNodes.elementAt(nodeFrom);
            Vertex to = (Vertex)this.abstractNodes.elementAt(nodeTo);
            Arc a = new Arc(from, to);
            a.setValue("request Size", capa);
            this.demands.add(a);
            this.abstractEdges.add(a);
            if (!this.mirrorRequest) continue;
            Arc aRev = new Arc(to, from);
            aRev.setValue("request Size", capa);
            this.demands.add(aRev);
            this.abstractEdges.add(aRev);
        }
    }

    private String getLine() {
        ++this.NO_LIGNE;
        String newL = "";
        while (newL.equals("")) {
            try {
                newL = this.reader.readLine();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (newL == null) {
                return null;
            }
            if (!newL.startsWith("//") && !newL.trim().equals("")) continue;
            newL = "";
            ++this.NO_LIGNE;
        }
        return newL;
    }

    public Iterator getAbstractNodes() {
        return this.abstractNodes.iterator();
    }

    public Iterator getAbstractVertices() {
        return this.abstractNodes.iterator();
    }

    public Iterator getAbstractEdges() {
        return this.abstractEdges.iterator();
    }

    public Iterator getAbstractNodeSets() {
        return this.abstractNodeSets.iterator();
    }

    public Iterator getAbstractVertexSets() {
        return this.abstractNodeSets.iterator();
    }

    public Iterator getAbstractEdgeSets() {
        return this.abstractEdgeSets.iterator();
    }

    public Iterator getAbstractChains() {
        return this.abstractChains.iterator();
    }

    public Iterator getAbstractPaths() {
        return this.abstractChains.iterator();
    }

    public Iterator getAbstractGraphs() {
        return this.abstractGraphs.iterator();
    }

    public Iterator getAllObjects() {
        Vector ret = new Vector();
        ret.addAll(this.abstractNodes);
        ret.addAll(this.abstractEdges);
        ret.addAll(this.abstractNodeSets);
        ret.addAll(this.abstractEdgeSets);
        ret.addAll(this.abstractChains);
        ret.addAll(this.abstractGraphs);
        return ret.iterator();
    }
}

