/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.graph;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.ArcSet;
import mascoptLib.graphs.DiPath;
import mascoptLib.graphs.Vertex;
import mascoptLib.io.ReaderInterface;
import mascoptLib.io.graph.NetReader;
import mascoptLib.util.Trace;

public class PathNetReader
extends NetReader
implements ReaderInterface {
    private boolean success = false;
    private Vector demandsRouted;
    private BufferedReader reader2;
    private int LINE_NO = 0;

    public PathNetReader(String fileNet, String filePath) {
        super(fileNet);
        Trace.println("Reading paths...");
        Trace.println("File Path " + filePath);
        this.demandsRouted = new Vector();
        try {
            this.reader2 = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.read2();
    }

    private void read2() {
        String line = this.getLine2();
        while (line != null) {
            StringTokenizer st = new StringTokenizer(line, " ");
            String read = st.nextToken();
            read = st.nextToken();
            int len = Integer.parseInt(st.nextToken());
            int demSize = Integer.parseInt(st.nextToken());
            int n1 = Integer.parseInt(st.nextToken());
            Vertex n_1 = this.findNode(n1);
            DiPath demand = new DiPath(this.cables);
            for (int j = 0; j < len; ++j) {
                int n2 = Integer.parseInt(st.nextToken());
                Vertex n_2 = this.findNode(n2);
                ArcSet arcset = (ArcSet)n_1.getEdgesTo(this.cables, (AbstractVertex)n_2);
                if (arcset.size() != 1) {
                    System.out.println("There has to be 1 and only 1 edge between two nodes, exiting ...");
                    return;
                }
                Iterator itA = arcset.iterator();
                Arc arc = (Arc)itA.next();
                demand.concat(arc);
                n1 = n2;
                n_1 = n_2;
            }
            this.demandsRouted.addElement(demand);
            for (int i = 0; i < demSize - 1; ++i) {
                Vertex nodeDem1;
                DiPath demandCopy = new DiPath(this.cables);
                Vertex nodeDem2 = nodeDem1 = demand.getStart();
                for (int j = 0; j < len; ++j) {
                    Arc arcDem = demand.nextArc(nodeDem1);
                    demandCopy.concat(arcDem);
                    nodeDem2 = nodeDem1 = demand.nextVertex(nodeDem2);
                }
                this.demandsRouted.addElement(demandCopy);
            }
            line = this.getLine2();
        }
        this.success = true;
    }

    private String getLine2() {
        ++this.LINE_NO;
        String newL = "";
        while (newL.equals("")) {
            try {
                newL = this.reader2.readLine();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (newL == null) {
                return null;
            }
            if (!newL.startsWith("//") && !newL.trim().equals("")) continue;
            newL = "";
            ++this.LINE_NO;
        }
        return newL;
    }

    private Vertex findNode(int id) {
        Iterator itN = super.getAbstractNodes();
        while (itN.hasNext()) {
            Vertex n = (Vertex)itN.next();
            if (Integer.parseInt(n.getValue("NetID")) != id) continue;
            return n;
        }
        System.out.println("The node in the path does not exist");
        return null;
    }

    public Vector getPaths() {
        if (this.success) {
            return this.demandsRouted;
        }
        System.out.println("Paths have not been constructed.. returning null");
        return null;
    }
}

