/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractEdgeSet;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.graphs.EdgeSet;
import mascoptLib.graphs.Graph;
import mascoptLib.graphs.Vertex;
import mascoptLib.gui.GraphChooser;

public class ClassWriter {
    private static final String HEADER = "\nimport mascoptLib.abstractGraph.*;\nimport mascoptLib.graphs.*;\n\n\n";
    private OutputStream os;

    public ClassWriter(AbstractGraph ag, String name, String packageName) {
        PrintStream ps = null;
        try {
            ps = new PrintStream(new FileOutputStream(name + ".java"));
        }
        catch (FileNotFoundException fne) {
            fne.printStackTrace();
        }
        if (packageName != null) {
            ps.println("package " + packageName + ";");
        }
        ps.println("");
        ps.println(HEADER);
        ps.println("public class " + name + " {");
        ps.println("");
        ps.println("");
        ps.println("    AbstractGraph ag ;");
        ps.println("");
        ps.println("    public " + name + "() {");
        ps.println("        NodeSet ns = new NodeSet();");
        Iterator it = ag.getAbstractVertexSet().iterator();
        while (it.hasNext()) {
            Vertex node = (Vertex)it.next();
            ps.println("        Node " + node.getId() + " = new Node(" + node.getX() + "," + node.getY() + ");" + "   " + node.getId() + ".setName(\"" + node.getName() + "\");   ns.add(" + node.getId() + ");");
        }
        ps.println("");
        String TYPE = "??";
        AbstractEdgeSet aes = ag.getAbstractEdgeSet();
        TYPE = aes instanceof EdgeSet ? "Edge" : "Arc";
        ps.println("        " + TYPE + "Set aes = new " + TYPE + "Set(ns);");
        it = aes.iterator();
        while (it.hasNext()) {
            AbstractEdge edge = (AbstractEdge)it.next();
            AbstractVertex[] nodes = edge.getAbstractVertices();
            ps.println("        " + TYPE + " " + edge.getId() + " = new " + TYPE + "(" + nodes[0] + "," + nodes[1] + ");" + "   aes.add(" + edge.getId() + ");");
        }
        ps.println("");
        if (ag instanceof Graph) {
            ps.println("        ag = new Graph(ns,aes);");
        } else {
            ps.println("        ag = new DiGraph(ns,aes);");
        }
        ps.println("    }");
        ps.println("");
        ps.println("");
        ps.println("    public AbstractGraph getGraph() {");
        ps.println("        return ag;");
        ps.println("    }");
        ps.println("}");
        System.out.println("Class " + name + ".java dumped");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("ClassWriter file.mgl name [packageName]");
        }
        AbstractGraph ag = GraphChooser.getGraphMGL(args[0]);
        String packageName = null;
        if (args.length == 3) {
            packageName = args[2];
        }
        new ClassWriter(ag, args[1], packageName);
        System.exit(0);
    }
}

