/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.util;

import java.util.Iterator;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.ArcSet;
import mascoptLib.graphs.DiGraph;
import mascoptLib.io.graph.GodReader;
import mascoptLib.io.graph.GodWriter;

public class OdFactor {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: java OdFactor file_1.graph file_2.od factor");
            System.out.println("Output: file_1.graph.factor file_2.od.factor");
        } else {
            int factor = Integer.parseInt(args[2]);
            System.out.println("Reading...");
            GodReader read = new GodReader(args[0], args[1]);
            Iterator itG = read.getAbstractGraphs();
            DiGraph g = (DiGraph)itG.next();
            Iterator itA = read.getAbstractEdgeSetRequest();
            itA.next();
            ArcSet demands = (ArcSet)itA.next();
            Iterator demand_iterateur = demands.iterator();
            while (demand_iterateur.hasNext()) {
                Arc arc = (Arc)demand_iterateur.next();
                Integer request_size = arc.getIntegerValue("request_size");
                int value = request_size * factor;
                arc.setIntegerValue("request_size", new Integer(value));
            }
            try {
                GodWriter writer = new GodWriter(args[0] + "." + factor, args[1] + "." + factor);
                System.out.println("Writing...");
                writer.add(g);
                writer.addAbstractEdgeSetRequest(demands);
                writer.write();
            }
            catch (Exception e) {
                System.out.println("Error in writing files !");
            }
        }
    }
}

