/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.util;

import java.util.Iterator;
import java.util.Observer;
import java.util.Vector;
import mascoptLib.util.NotifyReason;

public class ObservableObject {
    private Vector addObservers = new Vector();
    private Vector removeObservers = new Vector();
    private Vector valueObservers = new Vector();
    public static boolean stopNotifyValueMechanism = false;

    public void addAddObserver(Observer o) {
        this.addObservers.add(o);
    }

    public void deleteAddObserver(Observer o) {
        this.addObservers.remove(o);
    }

    public void deleteAddObserver() {
        this.addObservers.removeAllElements();
    }

    protected final void notifyAddObservers(NotifyReason nr) {
        int size = this.addObservers.size();
        for (int i = 0; i < size; ++i) {
            ((Observer)this.addObservers.elementAt(i)).update(null, nr);
        }
    }

    protected final void notifyAddObservers(Object[] objs) {
        this.notifyAddObservers(new NotifyReason("Add", objs));
    }

    public int countAddObservers() {
        return this.addObservers.size();
    }

    public void addRemoveObserver(Observer o) {
        this.removeObservers.add(o);
    }

    public void deleteRemoveObserver(Observer o) {
        while (this.removeObservers.remove(o)) {
        }
    }

    public void deleteRemoveObserver() {
        this.removeObservers.removeAllElements();
    }

    protected final void notifyRemoveObservers(NotifyReason nr) {
        int size = this.removeObservers.size();
        for (int i = 0; i < size; ++i) {
            ((Observer)this.removeObservers.elementAt(i)).update(null, nr);
        }
    }

    protected final void notifyRemoveObservers(Object[] objs) {
        this.notifyRemoveObservers(new NotifyReason("Remove", objs));
    }

    public int countRemoveObservers() {
        return this.removeObservers.size();
    }

    public void addValueObserver(Observer o) {
        this.valueObservers.add(o);
    }

    public void deleteValueObserver(Observer o) {
        this.valueObservers.remove(o);
    }

    public void deleteValueObserver() {
        this.valueObservers.removeAllElements();
    }

    protected final void notifyValueObservers(NotifyReason nr) {
        if (!stopNotifyValueMechanism) {
            Iterator itVO = this.valueObservers.iterator();
            while (itVO.hasNext()) {
                ((Observer)itVO.next()).update(null, nr);
            }
        }
    }

    protected final void notifyValueObservers(String message) {
        if (!stopNotifyValueMechanism) {
            Object[] t = new Object[]{this};
            this.notifyValueObservers(new NotifyReason(message, t));
        }
    }

    protected final void notifyValueObservers(String message, Object[] objs) {
        if (!stopNotifyValueMechanism) {
            this.notifyValueObservers(new NotifyReason(message, objs));
        }
    }

    public int countValueObservers() {
        return this.valueObservers.size();
    }
}

