/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class Trace {
    private static long[] oldTime = new long[20];
    private static boolean[] visible = new boolean[20];
    public static int ALL = 0;
    public static int ERROR = 1;
    public static int MEMORY = 2;
    private static Hashtable objectAlive = new Hashtable();

    public static void setVisible(boolean b) {
        Trace.setVisible(b, ALL);
    }

    public static void setVisible(boolean b, int level) {
        Trace.visible[level] = b;
    }

    public static void setVisibleErr(boolean b) {
        Trace.setVisible(b, ERROR);
    }

    public static void print(String s) {
        Trace.print(s, ALL);
    }

    public static void println(String s) {
        Trace.println(s, ALL);
    }

    public static void print(String s, int level) {
        if (visible[level]) {
            System.out.print(s);
        }
    }

    public static void println(String s, int level) {
        if (visible[level]) {
            System.out.println(s);
        }
    }

    public static void printErr(String s) {
        Trace.print(s, ERROR);
    }

    public static void printErrln(String s) {
        Trace.println(s, ERROR);
    }

    public static void startTime(int ref) {
        Trace.oldTime[ref] = System.currentTimeMillis();
    }

    public static long getTime(int ref) {
        return System.currentTimeMillis() - oldTime[ref];
    }

    public static synchronized void newObj(String id) {
        if (id == null) {
            Trace.println("Obj sans id !!!!", MEMORY);
        } else {
            objectAlive.put(id, id);
        }
    }

    public static synchronized void setNameObj(String id, String name) {
        if (id == null) {
            Trace.println("Obj sans id !!!!", MEMORY);
        } else {
            objectAlive.put(id, name);
        }
    }

    public static synchronized void finalizeObj(String id) {
        if (id == null) {
            Trace.println("Obj sans id !!!!", MEMORY);
        } else {
            objectAlive.remove(id);
        }
    }

    public static synchronized void printObjectsAlive() {
        Set ss = objectAlive.keySet();
        Iterator keys = ss.iterator();
        System.out.println("List of Objects Alive (" + ss.size() + ")-----------------------");
        while (keys.hasNext()) {
            String k = (String)keys.next();
            System.out.println("id=" + k + " name=" + objectAlive.get(k));
        }
        System.out.println("End of Objects Alive (" + ss.size() + ") ------------------------");
    }
}

