/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.util.fibHeap;

import java.util.Enumeration;
import java.util.Vector;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.util.fibHeap.FibComparator;
import mascoptLib.util.fibHeap.FibHeapNode;
import mascoptLib.util.fibHeap.PriorityQueue;
import mascoptLib.util.fibHeap.Underflow;

public class FibonacciHeap
implements PriorityQueue {
    int nodeNumber = 0;
    FibHeapNode minNode = null;
    FibComparator fc;
    private Vector indexFHN = null;
    private int indexFHNcpt = -1;
    private int insert = 0;
    private int detruit = 0;

    public FibonacciHeap(AbstractGraph g) {
        this.fc = new FibComparator(g);
        this.indexFHN = new Vector();
    }

    private void FibHeapInsert(FibHeapNode fhn) {
        fhn.left = fhn;
        fhn.right = fhn;
        if (this.minNode != null) {
            this.minNode.right.left = fhn;
            fhn.right = this.minNode.right;
            this.minNode.right = fhn;
            fhn.left = this.minNode;
        }
        if (this.minNode == null || this.fc.compare(fhn.element, this.minNode.element) < 0) {
            this.minNode = fhn;
        }
        ++this.nodeNumber;
    }

    public int insert(Object x) {
        if (this.isEmpty()) {
            this.indexFHN.clear();
            this.indexFHNcpt = -1;
        }
        ++this.indexFHNcpt;
        FibHeapNode fhn = new FibHeapNode(x, this.indexFHNcpt);
        this.indexFHN.add(this.indexFHNcpt, fhn);
        this.FibHeapInsert(fhn);
        ++this.insert;
        return this.indexFHNcpt;
    }

    public boolean isEmpty() {
        return this.minNode == null;
    }

    public void makeEmpty() {
        while (!this.isEmpty()) {
            try {
                this.deleteMin();
            }
            catch (Underflow u) {
                return;
            }
        }
        this.nodeNumber = 0;
        this.minNode = null;
    }

    public Object findMin() throws Underflow {
        if (this.minNode == null) {
            throw new Underflow("Null FibonacciHeap");
        }
        return this.minNode.element;
    }

    public void FibHeapUnion(FibHeapNode fhn, int n) {
        this.minNode.left.right = fhn.right;
        fhn.right.left = this.minNode.left;
        this.minNode.left = fhn;
        fhn.right = this.minNode;
        if (this.minNode == null || fhn != null && this.fc.compare(fhn.element, this.minNode.element) < 0) {
            this.minNode = fhn;
        }
        this.nodeNumber += n;
    }

    private FibHeapNode FibHeapExtractMin() {
        FibHeapNode z = this.minNode;
        if (z != null) {
            if (z.child != null) {
                FibHeapNode w;
                FibHeapNode t = w = z.child;
                do {
                    t.parent = null;
                } while ((t = t.right) != w);
                this.minNode.left.right = w.right;
                w.right.left = this.minNode.left;
                this.minNode.left = w;
                w.right = this.minNode;
            }
            z.left.right = z.right;
            z.right.left = z.left;
            if (z == z.right) {
                this.minNode = null;
            } else {
                this.minNode = z.right;
                this.Consolidate();
            }
            --this.nodeNumber;
            int index = z.getNumber();
            this.indexFHN.set(index, null);
            ++this.detruit;
        }
        return z;
    }

    public Object deleteMin() throws Underflow {
        FibHeapNode z = this.FibHeapExtractMin();
        if (z == null) {
            throw new Underflow("Null FibonacciHeap");
        }
        return z.element;
    }

    private void Consolidate() {
        FibHeapNode stop;
        if (this.isEmpty()) {
            return;
        }
        int k = (int)Math.floor(Math.sqrt(this.nodeNumber)) + 2;
        FibHeapNode[] a = new FibHeapNode[k];
        for (int i = 0; i < k; ++i) {
            a[i] = null;
        }
        FibHeapNode check = stop = this.minNode;
        do {
            FibHeapNode x;
            int d;
            if (a[d = x.degree] == (x = check)) continue;
            while (a[d] != null) {
                FibHeapNode y = a[d];
                if (this.fc.compare(y.element, x.element) < 0) {
                    FibHeapNode temp = x;
                    x = y;
                    y = temp;
                }
                this.FibHeapLink(y, x);
                stop = x;
                check = x;
                a[d] = null;
                ++d;
            }
            a[d] = x;
        } while ((check = check.right) != stop);
        this.minNode = stop;
        check = stop;
        do {
            if (this.fc.compare(check.element, this.minNode.element) >= 0) continue;
            this.minNode = check;
        } while ((check = check.right) != stop);
    }

    private void FibHeapLink(FibHeapNode y, FibHeapNode x) {
        y.left.right = y.right;
        y.right.left = y.left;
        if (x.child == null) {
            y.right = y;
            y.left = y;
            x.child = y;
        } else {
            y.right = x.child.right;
            y.left = x.child;
            x.child.right.left = y;
            x.child.right = y;
        }
        y.parent = x;
        ++x.degree;
        y.mark = false;
    }

    public void toss(Object x) {
        this.insert(x);
    }

    public void validate() {
        Vector<Object> v = new Vector<Object>(this.nodeNumber);
        while (!this.isEmpty()) {
            try {
                v.addElement(this.deleteMin());
            }
            catch (Underflow u) {
                return;
            }
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            this.insert(e.nextElement());
        }
        this.Consolidate();
    }

    public void FibHeapDecreaseKey(FibHeapNode x, Object k) throws Underflow {
        if (this.fc.compare(x.element, k) < 0) {
            throw new Underflow("new key is greater than current key");
        }
        x.element = k;
        FibHeapNode y = x.parent;
        if (y != null && this.fc.compare(x.element, y.element) < 0) {
            this.Cut(x, y);
            this.CascadingCut(y);
        }
        if (this.fc.compare(x.element, this.minNode.element) < 0) {
            this.minNode = x;
        }
    }

    private void Cut(FibHeapNode x, FibHeapNode y) {
        y.child = x.right == x ? null : x.right;
        x.left.right = x.right;
        x.right.left = x.left;
        --y.degree;
        this.minNode.right.left = x;
        x.right = this.minNode.right;
        this.minNode.right = x;
        x.left = this.minNode;
        x.parent = null;
        x.mark = false;
    }

    private void CascadingCut(FibHeapNode y) {
        FibHeapNode z = y.parent;
        if (z != null) {
            if (!y.mark) {
                y.mark = true;
            } else {
                this.Cut(y, z);
                this.CascadingCut(z);
            }
        }
    }

    public FibHeapNode getNode(int index) {
        if (this.indexFHN.get(index) != null) {
            return (FibHeapNode)this.indexFHN.get(index);
        }
        return null;
    }
}

